/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.docx;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import kz.greetgo.msoffice.docx.MSHelper;
import kz.greetgo.msoffice.docx.Table;
import kz.greetgo.msoffice.docx.TableCell;
import kz.greetgo.msoffice.docx.XmlWriter;

public class TableRow
implements XmlWriter {
    private final Table.TableInfo tableInfo;
    private final String ownerPartName;
    private final MSHelper msHelper;
    private List<TableCell> cells = new ArrayList<TableCell>();
    private Integer tblCellSpacing = 0;
    private Integer height;

    TableRow(Table.TableInfo tableInfo, String ownerPartName, MSHelper msHelper) {
        this.tableInfo = tableInfo;
        this.ownerPartName = ownerPartName;
        this.msHelper = msHelper;
    }

    public TableCell createCell() {
        TableCell ret = new TableCell(this.tableInfo.getTableCol(this.cells.size()), this.ownerPartName, this.msHelper);
        this.cells.add(ret);
        return ret;
    }

    public TableCell getCell(int index) {
        return this.cells.get(index);
    }

    @Override
    public void write(PrintStream out) {
        out.print("<w:tr>");
        out.print("<w:trPr>");
        out.print("<w:tblCellSpacing w:w=\"" + this.getTblCellSpacing() + "\" w:type=\"dxa\" />");
        if (this.getHeight() != null) {
            out.print("<w:trHeight w:val=\"" + this.getHeight() + "\" />");
        }
        out.print("</w:trPr>");
        for (TableCell c : this.cells) {
            c.write(out);
        }
        out.print("</w:tr>");
    }

    public Integer getTblCellSpacing() {
        return this.tblCellSpacing;
    }

    public void setTblCellSpacing(Integer tblCellSpacing) {
        this.tblCellSpacing = tblCellSpacing;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }
}

