/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.gen;

import kz.greetgo.msoffice.util.UtilOffice;

public class Color {
    private int alfa;
    private int red;
    private int green;
    private int blue;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public Color(int alfa, int red, int green, int blue) {
        this.alfa = alfa;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.checkValues();
    }

    public static Color copy(Color x) {
        if (x == null) {
            return null;
        }
        return new Color(x);
    }

    private void checkValues() {
        this.checkValue("alfa", this.alfa);
        this.checkValue("red", this.red);
        this.checkValue("green", this.green);
        this.checkValue("blue", this.blue);
    }

    private void checkValue(String valueName, int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Must be 0 <= " + valueName + " <= 255, but " + valueName + " = " + value);
        }
    }

    public Color(int red, int green, int blue) {
        this.alfa = 255;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.checkValues();
    }

    public Color(String hex) {
        if (hex.length() == 6) {
            this.alfa = 255;
            this.red = UtilOffice.parsePartAsHex(hex, 0, 2);
            this.green = UtilOffice.parsePartAsHex(hex, 2, 2);
            this.blue = UtilOffice.parsePartAsHex(hex, 4, 2);
            this.checkValues();
            return;
        }
        if (hex.length() == 8) {
            this.alfa = UtilOffice.parsePartAsHex(hex, 0, 2);
            this.red = UtilOffice.parsePartAsHex(hex, 2, 2);
            this.green = UtilOffice.parsePartAsHex(hex, 4, 2);
            this.blue = UtilOffice.parsePartAsHex(hex, 6, 2);
            this.checkValues();
            return;
        }
        throw new IllegalArgumentException("Cannot read color from " + hex);
    }

    public Color(Color c) {
        this.alfa = c.alfa;
        this.red = c.red;
        this.green = c.green;
        this.blue = c.blue;
    }

    public Color(java.awt.Color awtColor) {
        this.alfa = awtColor.getAlpha();
        this.red = awtColor.getRed();
        this.green = awtColor.getGreen();
        this.blue = awtColor.getBlue();
    }

    public String str() {
        StringBuilder ret = new StringBuilder();
        ret.append(DIGITS[this.alfa / 16]);
        ret.append(DIGITS[this.alfa % 16]);
        ret.append(DIGITS[this.red / 16]);
        ret.append(DIGITS[this.red % 16]);
        ret.append(DIGITS[this.green / 16]);
        ret.append(DIGITS[this.green % 16]);
        ret.append(DIGITS[this.blue / 16]);
        ret.append(DIGITS[this.blue % 16]);
        return ret.toString();
    }

    public String strRGB() {
        StringBuilder ret = new StringBuilder();
        ret.append(DIGITS[this.red / 16]);
        ret.append(DIGITS[this.red % 16]);
        ret.append(DIGITS[this.green / 16]);
        ret.append(DIGITS[this.green % 16]);
        ret.append(DIGITS[this.blue / 16]);
        ret.append(DIGITS[this.blue % 16]);
        return ret.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.alfa;
        result = 31 * result + this.blue;
        result = 31 * result + this.green;
        result = 31 * result + this.red;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Color other = (Color)obj;
        if (this.alfa != other.alfa) {
            return false;
        }
        if (this.blue != other.blue) {
            return false;
        }
        if (this.green != other.green) {
            return false;
        }
        return this.red == other.red;
    }

    public int getAlfa() {
        return this.alfa;
    }

    public void setAlfa(int alfa) {
        this.alfa = alfa;
    }

    public int getRed() {
        return this.red;
    }

    public void setRed(int red) {
        this.red = red;
    }

    public int getGreen() {
        return this.green;
    }

    public void setGreen(int green) {
        this.green = green;
    }

    public int getBlue() {
        return this.blue;
    }

    public void setBlue(int blue) {
        this.blue = blue;
    }

    public static final Color white() {
        return new Color(java.awt.Color.white);
    }

    public static final Color lightGray() {
        return new Color(java.awt.Color.lightGray);
    }

    public static final Color gray() {
        return new Color(java.awt.Color.gray);
    }

    public static final Color darkGray() {
        return new Color(java.awt.Color.darkGray);
    }

    public static final Color black() {
        return new Color(java.awt.Color.black);
    }

    public static final Color red() {
        return new Color(java.awt.Color.red);
    }

    public static final Color pink() {
        return new Color(java.awt.Color.pink);
    }

    public static final Color orange() {
        return new Color(java.awt.Color.orange);
    }

    public static final Color yellow() {
        return new Color(java.awt.Color.yellow);
    }

    public static final Color green() {
        return new Color(java.awt.Color.green);
    }

    public static final Color magenta() {
        return new Color(java.awt.Color.magenta);
    }

    public static final Color cyan() {
        return new Color(java.awt.Color.cyan);
    }

    public static final Color blue() {
        return new Color(java.awt.Color.blue);
    }
}

