/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.gen;

import java.io.PrintStream;
import kz.greetgo.msoffice.xlsx.gen.Alignment;
import kz.greetgo.msoffice.xlsx.gen.Borders;
import kz.greetgo.msoffice.xlsx.gen.Fill;
import kz.greetgo.msoffice.xlsx.gen.Font;
import kz.greetgo.msoffice.xlsx.gen.NumFmt;
import kz.greetgo.msoffice.xlsx.gen.PatternFill;
import kz.greetgo.msoffice.xlsx.gen.PatternFillType;
import kz.greetgo.msoffice.xlsx.gen.Styles;

public class Style {
    NumFmt numFmt;
    Font font;
    Fill fill;
    final Alignment alignment;
    final Borders borders;
    private final Styles styles;

    public void clean() {
        this.font = null;
        this.fill = null;
        this.alignment.clean();
        this.borders.clean();
        this.clearNumFmt();
    }

    public Font font() {
        if (this.font == null) {
            this.font = new Font();
        }
        return this.font;
    }

    public PatternFill patternFill() {
        if (this.fill instanceof PatternFill) {
            return (PatternFill)this.fill;
        }
        PatternFill ret = new PatternFill();
        this.fill = ret;
        return ret;
    }

    public Fill getFill() {
        if (this.fill == null) {
            return new PatternFill(PatternFillType.none);
        }
        return this.fill;
    }

    public void noFill() {
        this.fill = null;
    }

    int index() {
        return this.styles.styleIndex(this);
    }

    Style(Styles styles) {
        this.styles = styles;
        if (styles == null) {
            throw new NullPointerException("styles == null");
        }
        this.alignment = new Alignment();
        this.borders = new Borders();
    }

    Style(Style x) {
        this.numFmt = x.numFmt;
        this.font = Font.copy(x.font);
        this.fill = Fill.copy(x.fill);
        this.alignment = new Alignment(x.alignment);
        this.borders = Borders.copy(x.borders);
        this.styles = x.styles;
    }

    public Style copy() {
        return new Style(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alignment == null ? 0 : this.alignment.hashCode());
        result = 31 * result + (this.borders == null ? 0 : this.borders.hashCode());
        result = 31 * result + (this.fill == null ? 0 : this.fill.hashCode());
        result = 31 * result + (this.font == null ? 0 : this.font.hashCode());
        result = 31 * result + (this.numFmt == null ? 0 : this.numFmt.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Style other = (Style)obj;
        if (this.alignment == null ? other.alignment != null : !this.alignment.equals(other.alignment)) {
            return false;
        }
        if (this.borders == null ? other.borders != null : !this.borders.equals(other.borders)) {
            return false;
        }
        if (this.fill == null ? other.fill != null : !this.fill.equals(other.fill)) {
            return false;
        }
        if (this.font == null ? other.font != null : !this.font.equals(other.font)) {
            return false;
        }
        return this.numFmt == other.numFmt;
    }

    void clearNumFmt() {
        this.numFmt = null;
    }

    public Borders borders() {
        return this.borders;
    }

    public void print(PrintStream out) {
        out.print("<xf");
        boolean applyNumberFormat = false;
        if (this.numFmt == null) {
            out.print(" numFmtId=\"0\"");
        } else {
            out.print(" numFmtId=\"" + this.numFmt.getId() + "\"");
            applyNumberFormat = true;
        }
        int fontIndex = this.styles.fontIndex(this.font);
        out.print(" fontId=\"" + fontIndex + "\"");
        int bordersIndex = this.styles.bordersIndex(this.borders);
        out.print(" borderId=\"" + bordersIndex + "\"");
        int fillIndex = this.styles.fillIndex(this.fill);
        out.print(" fillId=\"" + fillIndex + "\"");
        if (bordersIndex > 0) {
            out.print(" applyBorder=\"1\"");
        }
        if (fontIndex > 0) {
            out.print(" applyFont=\"1\"");
        }
        if (fillIndex > 0) {
            out.print(" applyFill=\"1\"");
        }
        if (applyNumberFormat) {
            out.print(" applyNumberFormat=\"1\"");
        }
        if (!this.alignment.isStandart()) {
            out.print(" applyAlignment=\"1\"");
        }
        out.println(" xfId=\"0\" >");
        if (!this.alignment.isStandart()) {
            this.alignment.print(out);
        }
        out.println("</xf>");
    }

    public Alignment alignment() {
        return this.alignment;
    }
}

