/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.gen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import kz.greetgo.msoffice.util.UtilOffice;
import kz.greetgo.msoffice.xlsx.gen.Borders;
import kz.greetgo.msoffice.xlsx.gen.Chart;
import kz.greetgo.msoffice.xlsx.gen.ChartType;
import kz.greetgo.msoffice.xlsx.gen.Content;
import kz.greetgo.msoffice.xlsx.gen.PatternFillType;
import kz.greetgo.msoffice.xlsx.gen.Sheet;
import kz.greetgo.msoffice.xlsx.gen.Style;
import kz.greetgo.msoffice.xlsx.gen.Styles;
import kz.greetgo.msoffice.xlsx.parse.SharedStrings;

public class Xlsx {
    private final String tmpDirBase = System.getProperty("java.io.tmpdir", ".");
    private String workDir = null;
    private SharedStrings strs = null;
    private final Styles styles = new Styles();
    private final Content content;
    private final Map<String, Sheet> sheets = new HashMap<String, Sheet>();
    private int nextSheetIndex = 1;
    private boolean wasSelected = false;
    private final Set<Chart> charts = new HashSet<Chart>();
    private int chartFileIdLast = 0;
    private int imageFileIdLast = 0;
    private int drawingIdLast = 0;
    final Set<String> imageexts = new HashSet<String>();

    public Xlsx() {
        this.content = new Content(this);
        this.styles.styleIndex(new Style(this.styles));
        this.styles.bordersIndex(new Borders());
        Style s = new Style(this.styles);
        s.patternFill().setType(PatternFillType.gray125);
        this.styles.styleIndex(s);
    }

    public Sheet newSheet(boolean selected) {
        if (selected) {
            if (this.wasSelected) {
                throw new IllegalArgumentException("Selected sheet may be only one");
            }
            this.wasSelected = true;
        }
        Sheet ret = new Sheet(this, this.styles, this.nextSheetIndex++, this.workDir(), this.strs(), selected);
        this.sheets.put(ret.name(), ret);
        this.content.addSheet(ret);
        return ret;
    }

    public void setWorkDir(String workDir) {
        if (this.strs != null) {
            throw new IllegalStateException("Cannot change workDir after initialization");
        }
        this.workDir = workDir;
    }

    private String workDir() {
        if (this.workDir == null) {
            String newName = "xlsxGen-" + System.currentTimeMillis() + "-" + new Random().nextLong();
            this.workDir = this.tmpDirBase + "/" + newName;
            new File(this.workDir).mkdirs();
        }
        return this.workDir;
    }

    private SharedStrings strs() {
        try {
            if (this.strs == null) {
                this.strs = new SharedStrings(this.workDir());
            }
            return this.strs;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private void printStyles() throws Exception {
        String dir = this.workDir() + "/xl";
        new File(dir).mkdirs();
        PrintStream out = new PrintStream((OutputStream)new FileOutputStream(dir + "/styles.xml"), false, "UTF-8");
        this.styles.print(out);
        out.flush();
        out.close();
    }

    void finish() {
        try {
            this.finishInner();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private void finishInner() throws Exception {
        for (Sheet sheet : this.sheets.values()) {
            sheet.finish();
        }
        this.strs().close();
        this.printStyles();
        this.content.setWorkDir(this.workDir());
        this.content.finish();
    }

    void print(OutputStream out) {
        UtilOffice.zipDir(this.workDir(), out);
    }

    void close() {
        UtilOffice.removeDir(this.workDir());
    }

    public void complete(OutputStream out) {
        try {
            this.finish();
            this.print(out);
        }
        finally {
            this.close();
        }
    }

    public Chart newChart(ChartType type, int relid) {
        Chart chart = new Chart(type, ++this.chartFileIdLast, relid);
        this.charts.add(chart);
        return chart;
    }

    public int newImageFileId() {
        return ++this.imageFileIdLast;
    }

    public void add(Chart chart) {
        this.charts.add(chart);
    }

    Set<Chart> getCharts() {
        return this.charts;
    }

    int getDrawingIdNext() {
        return ++this.drawingIdLast;
    }

    public static void main(String[] args) {
        System.out.println(new File(System.getProperty("java.io.tmpDir", ".")).getAbsolutePath());
    }
}

