/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.reader;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractXmlHandler
extends DefaultHandler {
    private final List<String> tags = new ArrayList<String>();
    private final StringBuilder characters = new StringBuilder();

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.tags.add(localName);
        this.characters.setLength(0);
        try {
            this.startTag(this.tagPath(), attributes);
        }
        catch (RuntimeException | SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String tagPath() {
        return "/" + String.join((CharSequence)"/", this.tags);
    }

    protected abstract void startTag(String var1, Attributes var2) throws Exception;

    @Override
    public void characters(char[] ch, int start, int length) {
        this.characters.append(ch, start, length);
    }

    protected String text() {
        return this.characters.toString();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.endTag(this.tagPath());
            this.tags.remove(this.tags.size() - 1);
            this.characters.setLength(0);
        }
        catch (RuntimeException | SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void endTag(String var1) throws Exception;
}

