/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.reader;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import kz.greetgo.msoffice.xlsx.reader.CellReader;
import kz.greetgo.msoffice.xlsx.reader.SheetReader;
import kz.greetgo.msoffice.xlsx.reader.StoredStrings;
import kz.greetgo.msoffice.xlsx.reader.model.Border4;
import kz.greetgo.msoffice.xlsx.reader.model.BorderSide;
import kz.greetgo.msoffice.xlsx.reader.model.BorderStyle;
import kz.greetgo.msoffice.xlsx.reader.model.CellXf;
import kz.greetgo.msoffice.xlsx.reader.model.ColData;
import kz.greetgo.msoffice.xlsx.reader.model.StylesData;

public class XlsxReaderContext {
    public DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    public final StoredStrings storedStrings;
    public final StylesData styles = new StylesData();
    private static final Border4 EMPTY = new Border4();

    public XlsxReaderContext(StoredStrings storedStrings) {
        this.storedStrings = storedStrings;
    }

    public String dateToStr(Date date) {
        return date == null ? null : this.dateFormat.format(date);
    }

    public BorderStyle getBorderStyle(BorderSide borderSide, int rowIndex, ColData col, SheetReader sheetReader) {
        Border4 border4 = this.getBorder4(col.style);
        BorderStyle style = border4.get((BorderSide)borderSide).style;
        if (style != null && style != BorderStyle.NONE) {
            return style;
        }
        int[] coordinates = new int[]{rowIndex, col.col};
        int[] newCoordinates = borderSide.move(coordinates);
        if (newCoordinates[0] == coordinates[0] && newCoordinates[1] == coordinates[1]) {
            return BorderStyle.NONE;
        }
        if (newCoordinates[0] < 0 || newCoordinates[1] < 0) {
            return BorderStyle.NONE;
        }
        CellReader cell = sheetReader.row(newCoordinates[0]).cell(newCoordinates[1]);
        Border4 border42 = this.getBorder4(cell.col.style);
        BorderStyle style2 = border42.get((BorderSide)borderSide.mirror()).style;
        return style2 != null ? style2 : BorderStyle.NONE;
    }

    private Border4 getBorder4(int style) {
        if (style == 0 && this.styles.cellXfList.isEmpty()) {
            return EMPTY;
        }
        CellXf cellXf = this.styles.cellXfList.get(style);
        int borderId = cellXf.borderId();
        if (borderId == 0 && this.styles.border4List.isEmpty()) {
            return EMPTY;
        }
        return this.styles.border4List.get(borderId);
    }
}

