/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.reader.model;

import kz.greetgo.msoffice.util.BinUtil;
import kz.greetgo.msoffice.xlsx.reader.model.ValueType;

public class ColData {
    public ValueType valueType;
    public int col;
    public int style;
    public String value;

    public static ColData empty(int colIndex) {
        ColData ret = new ColData();
        ret.col = colIndex;
        ret.style = 0;
        ret.valueType = ValueType.UNKNOWN;
        ret.value = null;
        return ret;
    }

    public int byteSize() {
        return 10 + BinUtil.sizeOfStr(this.value);
    }

    public void writeBytes(byte[] buffer, int offset) {
        short valueTypeInt = (short)(this.valueType == null ? ValueType.UNKNOWN.ordinal() : this.valueType.ordinal());
        BinUtil.writeShort(valueTypeInt, buffer, offset);
        BinUtil.writeInt(this.col, buffer, offset + 2);
        BinUtil.writeInt(this.style, buffer, offset + 2 + 4);
        BinUtil.writeStr(this.value, buffer, offset + 2 + 8);
    }

    public static ColData readBytes(byte[] buffer, int offset) {
        ColData colData = new ColData();
        colData.valueType = ValueType.values()[BinUtil.readShort(buffer, offset)];
        colData.col = BinUtil.readInt(buffer, offset + 2);
        colData.style = BinUtil.readInt(buffer, offset + 2 + 4);
        colData.value = BinUtil.readStr(buffer, offset + 2 + 8);
        return colData;
    }
}

