/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.reader.model;

import kz.greetgo.msoffice.util.BinUtil;
import kz.greetgo.msoffice.util.UtilOffice;

public class MergeCell {
    public int rowFrom;
    public int rowTo;
    public int colFrom;
    public int colTo;

    public void parseAndSet(String ref) {
        String[] split = ref.split(":");
        int[] from = UtilOffice.parseCellCoordinate(split[0]);
        int[] to = UtilOffice.parseCellCoordinate(split[1]);
        this.colFrom = from[0] - 1;
        this.rowFrom = from[1] - 1;
        this.colTo = to[0] - 1;
        this.rowTo = to[1] - 1;
    }

    public String toString() {
        return "MergeCell{rows=" + this.rowFrom + ".." + this.rowTo + ", cols=" + this.colFrom + ".." + this.colTo + '}';
    }

    public void writeBytes(byte[] buffer, int offset) {
        BinUtil.writeInt(this.rowFrom, buffer, offset);
        BinUtil.writeInt(this.rowTo, buffer, offset + 4);
        BinUtil.writeInt(this.colFrom, buffer, offset + 8);
        BinUtil.writeInt(this.colTo, buffer, offset + 12);
    }

    public static MergeCell readFrom(byte[] buffer, int offset) {
        MergeCell ret = new MergeCell();
        ret.rowFrom = BinUtil.readInt(buffer, offset);
        ret.rowTo = BinUtil.readInt(buffer, offset + 4);
        ret.colFrom = BinUtil.readInt(buffer, offset + 8);
        ret.colTo = BinUtil.readInt(buffer, offset + 12);
        return ret;
    }

    public int byteSize() {
        return 16;
    }
}

