/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.reader.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kz.greetgo.msoffice.util.BinUtil;
import kz.greetgo.msoffice.xlsx.reader.model.ColData;

public class RowData {
    public BigDecimal height;
    public final List<ColData> cols = new ArrayList<ColData>();
    private static final RowData EMPTY = new RowData();

    public double heightAsDouble() {
        return this.height == null ? 15.0 : this.height.doubleValue();
    }

    public static RowData empty() {
        return EMPTY;
    }

    public void writeTo(byte[] buffer, int offset) {
        int i = offset;
        BinUtil.writeBd(this.height, buffer, i);
        BinUtil.writeInt(this.cols.size(), buffer, i += BinUtil.sizeOfBd(this.height));
        i += 4;
        for (ColData col : this.cols) {
            col.writeBytes(buffer, i);
            i += col.byteSize();
        }
    }

    public static RowData readFrom(byte[] buffer, int offset) {
        int i = offset;
        RowData ret = new RowData();
        ret.height = BinUtil.readBd(buffer, i);
        int size = BinUtil.readInt(buffer, i += BinUtil.sizeOfBd(ret.height));
        i += 4;
        for (int j = 0; j < size; ++j) {
            ColData colData = ColData.readBytes(buffer, i);
            i += colData.byteSize();
            ret.cols.add(colData);
        }
        return ret;
    }

    public int byteSize() {
        int ret = BinUtil.sizeOfBd(this.height) + 4;
        for (ColData col : this.cols) {
            ret += col.byteSize();
        }
        return ret;
    }
}

