/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.crypto;

import java.util.Objects;
import kz.greetgo.db.DbType;
import kz.greetgo.db.Jdbc;
import kz.greetgo.security.crypto.Crypto;
import kz.greetgo.security.crypto.CryptoBuilder;
import kz.greetgo.security.crypto.CryptoSourceConfig;
import kz.greetgo.security.crypto.errors.NotEqualsIdFieldLengths;
import kz.greetgo.security.crypto.errors.NotSameIdFieldNames;
import kz.greetgo.security.crypto.errors.UnsupportedDb;
import kz.greetgo.security.crypto.jdbc.ContentNames;
import kz.greetgo.security.crypto.jdbc.DbDialect;
import kz.greetgo.security.crypto.jdbc.DbDialectOracle;
import kz.greetgo.security.crypto.jdbc.DbDialectPostgres;
import kz.greetgo.security.crypto.jdbc.JdbcContentAccess;
import kz.greetgo.security.crypto.jdbc.create_table.CreateTable;

public class CryptoBuilderKeysInDb {
    private final CryptoBuilder parent;
    private final DbType dbType;
    private final Jdbc jdbc;
    private final Names namesForPrivateKey = new Names("private.key");
    private final Names namesForPublicKey = new Names("public.key");
    private int privateIdFieldLength = 50;
    private int publicIdFieldLength = 50;

    public CryptoBuilderKeysInDb(CryptoBuilder parent, DbType dbType, Jdbc jdbc) {
        this.parent = parent;
        this.dbType = dbType;
        this.jdbc = jdbc;
    }

    public CryptoBuilderKeysInDb setConfig(CryptoSourceConfig config) {
        this.parent.setConfig(config);
        return this;
    }

    public CryptoBuilderKeysInDb setTableName(String tableName) {
        return this.setTableNameForPrivateKey(tableName).setTableNameForPublicKey(tableName);
    }

    public CryptoBuilderKeysInDb setTableNameForPrivateKey(String tableName) {
        Objects.requireNonNull(tableName);
        this.namesForPrivateKey.tableName = tableName;
        return this;
    }

    public CryptoBuilderKeysInDb setTableNameForPublicKey(String tableName) {
        Objects.requireNonNull(tableName);
        this.namesForPublicKey.tableName = tableName;
        return this;
    }

    public CryptoBuilderKeysInDb setIdFieldName(String idFieldName) {
        return this.setIdFieldNameForPrivateKey(idFieldName).setIdFieldNameForPublicKey(idFieldName);
    }

    public CryptoBuilderKeysInDb setIdFieldNameForPrivateKey(String idFieldName) {
        Objects.requireNonNull(idFieldName);
        this.namesForPrivateKey.idFieldName = idFieldName;
        return this;
    }

    public CryptoBuilderKeysInDb setIdFieldNameForPublicKey(String idFieldName) {
        Objects.requireNonNull(idFieldName);
        this.namesForPublicKey.idFieldName = idFieldName;
        return this;
    }

    public CryptoBuilderKeysInDb setPrivateKeyIdValue(String idValue) {
        Objects.requireNonNull(idValue);
        this.namesForPrivateKey.idValue = idValue;
        return this;
    }

    public CryptoBuilderKeysInDb setPublicKeyIdValue(String idValue) {
        Objects.requireNonNull(idValue);
        this.namesForPublicKey.idValue = idValue;
        return this;
    }

    public CryptoBuilderKeysInDb setValueFieldName(String valueFieldName) {
        return this.setValueFieldNameForPrivateKey(valueFieldName).setValueFieldNameForPublicKey(valueFieldName);
    }

    public CryptoBuilderKeysInDb setValueFieldNameForPrivateKey(String valueFieldName) {
        Objects.requireNonNull(valueFieldName);
        this.namesForPrivateKey.valueFieldName = valueFieldName;
        return this;
    }

    public CryptoBuilderKeysInDb setValueFieldNameForPublicKey(String valueFieldName) {
        Objects.requireNonNull(valueFieldName);
        this.namesForPublicKey.valueFieldName = valueFieldName;
        return this;
    }

    public CryptoBuilderKeysInDb setIdFieldLength(int idFieldLength) {
        return this.setPrivateIdFieldLength(idFieldLength).setPublicIdFieldLength(idFieldLength);
    }

    public CryptoBuilderKeysInDb setPrivateIdFieldLength(int privateIdFieldLength) {
        this.privateIdFieldLength = privateIdFieldLength;
        return this;
    }

    public CryptoBuilderKeysInDb setPublicIdFieldLength(int publicIdFieldLength) {
        this.publicIdFieldLength = publicIdFieldLength;
        return this;
    }

    public Crypto build() {
        String createTableDDL_privateKey;
        String createTableDDL_publicKey;
        DbDialect dialect = this.calcDialect();
        ContentNames privateKeyNames = this.namesForPrivateKey.fix();
        ContentNames publicKeyNames = this.namesForPublicKey.fix();
        if (Objects.equals(privateKeyNames.tableName, publicKeyNames.tableName)) {
            if (!Objects.equals(privateKeyNames.idFieldName, publicKeyNames.idFieldName)) {
                throw new NotSameIdFieldNames(privateKeyNames.idFieldName, publicKeyNames.idFieldName);
            }
            if (this.privateIdFieldLength != this.publicIdFieldLength) {
                throw new NotEqualsIdFieldLengths(this.privateIdFieldLength, this.publicIdFieldLength);
            }
            boolean sameValueFields = Objects.equals(privateKeyNames.valueFieldName, publicKeyNames.valueFieldName);
            CreateTable createTable = new CreateTable(privateKeyNames.tableName);
            createTable.newField(privateKeyNames.idFieldName).typeString(this.privateIdFieldLength).primaryKey();
            createTable.newField(privateKeyNames.valueFieldName).setNotNull(sameValueFields).typeBlob();
            if (!sameValueFields) {
                createTable.newField(publicKeyNames.valueFieldName).typeBlob();
            }
            createTableDDL_privateKey = createTableDDL_publicKey = dialect.toCreateTableDDL(createTable);
        } else {
            CreateTable createTable = new CreateTable(privateKeyNames.tableName);
            createTable.newField(privateKeyNames.idFieldName).primaryKey().typeString(this.privateIdFieldLength);
            createTable.newField(privateKeyNames.valueFieldName).typeBlob().notNull();
            createTableDDL_privateKey = dialect.toCreateTableDDL(createTable);
            createTable = new CreateTable(publicKeyNames.tableName);
            createTable.newField(publicKeyNames.idFieldName).primaryKey().typeString(this.publicIdFieldLength);
            createTable.newField(publicKeyNames.valueFieldName).typeBlob().notNull();
            createTableDDL_publicKey = dialect.toCreateTableDDL(createTable);
        }
        JdbcContentAccess privateKeyAccess = new JdbcContentAccess(this.jdbc, privateKeyNames, createTableDDL_privateKey, dialect);
        JdbcContentAccess publicKeyAccess = new JdbcContentAccess(this.jdbc, publicKeyNames, createTableDDL_publicKey, dialect);
        return this.parent.build(privateKeyAccess, publicKeyAccess);
    }

    private DbDialect calcDialect() {
        switch (this.dbType) {
            case Postgres: {
                return new DbDialectPostgres();
            }
            case Oracle: {
                return new DbDialectOracle();
            }
        }
        throw new UnsupportedDb(this.dbType);
    }

    private static class Names {
        public String tableName = "crypto_keys";
        public String idFieldName = "id";
        public String idValue;
        public String valueFieldName = "content";

        public Names(String idValue) {
            this.idValue = idValue;
        }

        ContentNames fix() {
            return new ContentNames(this.tableName, this.idFieldName, this.idValue, this.valueFieldName);
        }
    }
}

