/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.session;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kz.greetgo.db.ConnectionCallback;
import kz.greetgo.security.crypto.errors.SqlWrapper;
import kz.greetgo.security.session.Serializer;
import kz.greetgo.security.session.SessionIdentity;
import kz.greetgo.security.session.SessionRow;
import kz.greetgo.security.session.SessionStorage;
import kz.greetgo.security.session.SessionStorageBuilder;
import kz.greetgo.security.session.jdbc.SelectDateOrNull;
import kz.greetgo.security.session.jdbc.SelectFirstOrNull;
import kz.greetgo.security.session.jdbc.SelectStrOrNull;
import kz.greetgo.security.session.jdbc.Update;
import kz.greetgo.security.util.ErrorUtil;

public abstract class AbstractSessionStorageAdapter
implements SessionStorage {
    protected final SessionStorageBuilder.Names names;

    public AbstractSessionStorageAdapter(SessionStorageBuilder.Names names) {
        this.names = names;
        this.init();
    }

    private void init() {
        try {
            this.names.jdbc.execute((ConnectionCallback)new SelectStrOrNull(this.checkTableExistsSql()));
        }
        catch (RuntimeException e) {
            SQLException sqlException = ErrorUtil.extractSqlException(e);
            if (sqlException != null) {
                if (this.isExceptionAboutTableDoesNotExists(sqlException)) {
                    this.createSessionTable();
                    return;
                }
                throw new SqlWrapper(sqlException);
            }
            throw e;
        }
    }

    private void createSessionTable() {
        this.names.jdbc.execute((ConnectionCallback)new Update(this.createSessionTableSql()));
    }

    protected abstract String createSessionTableSql();

    protected abstract boolean isExceptionAboutTableDoesNotExists(SQLException var1);

    protected abstract String checkTableExistsSql();

    protected abstract String insertSessionSql(List<Object> var1, SessionIdentity var2, Object var3);

    @Override
    public void insertSession(SessionIdentity identity, Object sessionData) {
        ArrayList<Object> sqlParams = new ArrayList<Object>();
        String sql = this.insertSessionSql(sqlParams, identity, sessionData);
        this.names.jdbc.execute((ConnectionCallback)new Update(sql, sqlParams));
    }

    @Override
    public boolean zeroSessionAge(String sessionId) {
        ArrayList<Object> sqlParams = new ArrayList<Object>();
        String sql = this.zeroSessionAgeSql(sqlParams, sessionId);
        return (Integer)this.names.jdbc.execute((ConnectionCallback)new Update(sql, sqlParams)) > 0;
    }

    protected abstract String zeroSessionAgeSql(List<Object> var1, String var2);

    @Override
    public Date loadLastTouchedAt(String sessionId) {
        ArrayList<Object> sqlParams = new ArrayList<Object>();
        String sql = this.loadLastTouchedAtSql(sqlParams, sessionId);
        return (Date)this.names.jdbc.execute((ConnectionCallback)new SelectDateOrNull(sql, sqlParams));
    }

    protected abstract String loadLastTouchedAtSql(List<Object> var1, String var2);

    @Override
    public int removeSessionsOlderThan(int ageInHours) {
        ArrayList<Object> sqlParams = new ArrayList<Object>();
        String sql = this.removeSessionsOlderThanSql(sqlParams, ageInHours);
        return (Integer)this.names.jdbc.execute((ConnectionCallback)new Update(sql, sqlParams));
    }

    protected abstract String removeSessionsOlderThanSql(List<Object> var1, int var2);

    @Override
    public SessionRow loadSession(String sessionId) {
        String sql = "select * from " + this.names.tableName + " where " + this.names.id + " = ?";
        return (SessionRow)this.names.jdbc.execute(new SelectFirstOrNull<SessionRow>(sql, Collections.singletonList(sessionId), rs -> {
            String token = rs.getString(this.names.token);
            Object sessionData = Serializer.deserialize(rs.getBytes(this.names.sessionData));
            Timestamp insertedAt = rs.getTimestamp(this.names.insertedAt);
            Timestamp lastTouchedAt = rs.getTimestamp(this.names.lastTouchedAt);
            return new SessionRow(token, sessionData, insertedAt, lastTouchedAt);
        }));
    }

    @Override
    public boolean remove(String sessionId) {
        String sql = "delete from " + this.names.tableName + " where " + this.names.id + " = ?";
        return (Integer)this.names.jdbc.execute((ConnectionCallback)new Update(sql, Collections.singletonList(sessionId))) > 0;
    }

    @Override
    public boolean setLastTouchedAt(String sessionId, Date lastTouchedAt) {
        Objects.requireNonNull(lastTouchedAt, "lastTouchedAt cannot be null");
        String sql = " update " + this.names.tableName + " set    " + this.names.lastTouchedAt + " = ? where  " + this.names.id + " = ?";
        return (Integer)this.names.jdbc.execute((ConnectionCallback)new Update(sql, Arrays.asList(new Timestamp(lastTouchedAt.getTime()), sessionId))) > 0;
    }
}

