/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.session;

import java.sql.SQLException;
import java.util.List;
import kz.greetgo.security.session.AbstractSessionStorageAdapter;
import kz.greetgo.security.session.Serializer;
import kz.greetgo.security.session.SessionIdentity;
import kz.greetgo.security.session.SessionStorage;
import kz.greetgo.security.session.SessionStorageBuilder;

class SessionStoragePostgresAdapter
extends AbstractSessionStorageAdapter
implements SessionStorage {
    SessionStoragePostgresAdapter(SessionStorageBuilder.Names names) {
        super(names);
    }

    @Override
    protected String checkTableExistsSql() {
        return "select " + this.names.id + " from " + this.names.tableName + " limit 1";
    }

    @Override
    protected String insertSessionSql(List<Object> sqlParams, SessionIdentity identity, Object sessionData) {
        sqlParams.add(identity.id);
        sqlParams.add(identity.token);
        sqlParams.add(Serializer.serialize(sessionData));
        return "insert into " + this.names.tableName + " (" + this.names.id + ", " + this.names.token + ", " + this.names.sessionData + ") values (?, ?, ?)";
    }

    @Override
    protected String createSessionTableSql() {
        return "create table " + this.names.tableName + " (  " + this.names.id + " varchar(50) not null,  " + this.names.token + " varchar(50),  " + this.names.sessionData + " byTea,  " + this.names.insertedAt + " timestamp not null default clock_timestamp(),  " + this.names.lastTouchedAt + " timestamp not null default clock_timestamp(),  primary key(" + this.names.id + "))";
    }

    @Override
    protected boolean isExceptionAboutTableDoesNotExists(SQLException sqlException) {
        return "42P01".equals(sqlException.getSQLState());
    }

    @Override
    protected String loadLastTouchedAtSql(List<Object> sqlParams, String sessionId) {
        sqlParams.add(sessionId);
        return "select " + this.names.lastTouchedAt + " from " + this.names.tableName + " where " + this.names.id + " = ?";
    }

    @Override
    protected String zeroSessionAgeSql(List<Object> sqlParams, String sessionId) {
        sqlParams.add(sessionId);
        return "update " + this.names.tableName + " set " + this.names.lastTouchedAt + " = clock_timestamp() where " + this.names.id + " = ?";
    }

    @Override
    protected String removeSessionsOlderThanSql(List<Object> sqlParams, int ageInHours) {
        return "delete from " + this.names.tableName + " where " + this.names.lastTouchedAt + " < clock_timestamp() - interval '" + ageInHours + " hours'";
    }
}

