/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.crypto;

import java.util.Objects;
import kz.greetgo.db.DbType;
import kz.greetgo.db.Jdbc;
import kz.greetgo.security.crypto.Crypto;
import kz.greetgo.security.crypto.CryptoBuilder;
import kz.greetgo.security.crypto.CryptoSourceConfig;
import kz.greetgo.security.crypto.errors.NotEqualsIdFieldLengths;
import kz.greetgo.security.crypto.errors.UnsupportedDb;
import kz.greetgo.security.crypto.jdbc.ContentNames;
import kz.greetgo.security.crypto.jdbc.DbDialect;
import kz.greetgo.security.crypto.jdbc.DbDialectOracle;
import kz.greetgo.security.crypto.jdbc.DbDialectPostgres;
import kz.greetgo.security.crypto.jdbc.JdbcContentAccess;
import kz.greetgo.security.crypto.jdbc.create_table.CreateTable;

public class CryptoBuilderKeysInDb {
    private final CryptoBuilder parent;
    private final DbType dbType;
    private final Jdbc jdbc;
    private final Names namesForPrivateKey = new Names("private.key");
    private final Names namesForPublicKey = new Names("public.key");
    private int privateIdFieldLength = 50;
    private int publicIdFieldLength = 50;
    String createTableDDL_privateKey;
    String createTableDDL_publicKey;
    DbDialect dialect;
    ContentNames privateKeyNames = this.namesForPrivateKey.fix();
    ContentNames publicKeyNames = this.namesForPublicKey.fix();

    public CryptoBuilderKeysInDb(CryptoBuilder parent, DbType dbType, Jdbc jdbc) {
        this.parent = parent;
        this.dbType = dbType;
        this.jdbc = jdbc;
    }

    public CryptoBuilderKeysInDb setConfig(CryptoSourceConfig config) {
        this.parent.setConfig(config);
        return this;
    }

    public CryptoBuilderKeysInDb setTableName(String tableName) {
        return this.setTableNameForPrivateKey(tableName).setTableNameForPublicKey(tableName);
    }

    public CryptoBuilderKeysInDb setTableNameForPrivateKey(String tableName) {
        Objects.requireNonNull(tableName);
        this.namesForPrivateKey.tableName = tableName;
        return this;
    }

    public CryptoBuilderKeysInDb setTableNameForPublicKey(String tableName) {
        Objects.requireNonNull(tableName);
        this.namesForPublicKey.tableName = tableName;
        return this;
    }

    public CryptoBuilderKeysInDb setIdFieldName(String idFieldName) {
        return this.setIdFieldNameForPrivateKey(idFieldName).setIdFieldNameForPublicKey(idFieldName);
    }

    public CryptoBuilderKeysInDb setIdFieldNameForPrivateKey(String idFieldName) {
        Objects.requireNonNull(idFieldName);
        this.namesForPrivateKey.idFieldName = idFieldName;
        return this;
    }

    public CryptoBuilderKeysInDb setIdFieldNameForPublicKey(String idFieldName) {
        Objects.requireNonNull(idFieldName);
        this.namesForPublicKey.idFieldName = idFieldName;
        return this;
    }

    public CryptoBuilderKeysInDb setPrivateKeyIdValue(String idValue) {
        Objects.requireNonNull(idValue);
        this.namesForPrivateKey.idValue = idValue;
        return this;
    }

    public CryptoBuilderKeysInDb setPublicKeyIdValue(String idValue) {
        Objects.requireNonNull(idValue);
        this.namesForPublicKey.idValue = idValue;
        return this;
    }

    public CryptoBuilderKeysInDb setValueFieldName(String valueFieldName) {
        return this.setValueFieldNameForPrivateKey(valueFieldName).setValueFieldNameForPublicKey(valueFieldName);
    }

    public CryptoBuilderKeysInDb setValueFieldNameForPrivateKey(String valueFieldName) {
        Objects.requireNonNull(valueFieldName);
        this.namesForPrivateKey.valueFieldName = valueFieldName;
        return this;
    }

    public CryptoBuilderKeysInDb setValueFieldNameForPublicKey(String valueFieldName) {
        Objects.requireNonNull(valueFieldName);
        this.namesForPublicKey.valueFieldName = valueFieldName;
        return this;
    }

    public CryptoBuilderKeysInDb setIdFieldLength(int idFieldLength) {
        return this.setPrivateIdFieldLength(idFieldLength).setPublicIdFieldLength(idFieldLength);
    }

    public CryptoBuilderKeysInDb setPrivateIdFieldLength(int privateIdFieldLength) {
        this.privateIdFieldLength = privateIdFieldLength;
        return this;
    }

    public CryptoBuilderKeysInDb setPublicIdFieldLength(int publicIdFieldLength) {
        this.publicIdFieldLength = publicIdFieldLength;
        return this;
    }

    private void prepareDDL() {
        if (Objects.equals(this.privateKeyNames.tableName, this.publicKeyNames.tableName)) {
            if (this.privateIdFieldLength != this.publicIdFieldLength) {
                throw new NotEqualsIdFieldLengths(this.privateIdFieldLength, this.publicIdFieldLength);
            }
            boolean sameValueFields = Objects.equals(this.privateKeyNames.valueFieldName, this.publicKeyNames.valueFieldName);
            CreateTable createTable = new CreateTable(this.privateKeyNames.tableName);
            createTable.newField(this.privateKeyNames.idFieldName).typeString(this.privateIdFieldLength).primaryKey();
            createTable.newField(this.privateKeyNames.valueFieldName).setNotNull(sameValueFields).typeBlob();
            if (!sameValueFields) {
                createTable.newField(this.publicKeyNames.valueFieldName).typeBlob();
            }
            this.createTableDDL_privateKey = this.createTableDDL_publicKey = this.dialect.generateCreateTableDDL(createTable);
        } else {
            CreateTable createTable = new CreateTable(this.privateKeyNames.tableName);
            createTable.newField(this.privateKeyNames.idFieldName).primaryKey().typeString(this.privateIdFieldLength);
            createTable.newField(this.privateKeyNames.valueFieldName).typeBlob().notNull();
            this.createTableDDL_privateKey = this.dialect.generateCreateTableDDL(createTable);
            createTable = new CreateTable(this.publicKeyNames.tableName);
            createTable.newField(this.publicKeyNames.idFieldName).primaryKey().typeString(this.publicIdFieldLength);
            createTable.newField(this.publicKeyNames.valueFieldName).typeBlob().notNull();
            this.createTableDDL_publicKey = this.dialect.generateCreateTableDDL(createTable);
        }
    }

    private DbDialect calcDialect() {
        switch (this.dbType) {
            case Postgres: {
                return new DbDialectPostgres();
            }
            case Oracle: {
                return new DbDialectOracle();
            }
        }
        throw new UnsupportedDb(this.dbType);
    }

    public Crypto build() {
        this.dialect = this.calcDialect();
        this.prepareDDL();
        JdbcContentAccess privateKeyAccess = new JdbcContentAccess(this.jdbc, this.privateKeyNames, this.createTableDDL_privateKey, this.dialect);
        JdbcContentAccess publicKeyAccess = new JdbcContentAccess(this.jdbc, this.publicKeyNames, this.createTableDDL_publicKey, this.dialect);
        return this.parent.build(privateKeyAccess, publicKeyAccess);
    }

    private static class Names {
        public String tableName = "crypto_keys";
        public String idFieldName = "id";
        public String idValue;
        public String valueFieldName = "content";

        public Names(String idValue) {
            this.idValue = idValue;
        }

        ContentNames fix() {
            return new ContentNames(this.tableName, this.idFieldName, this.idValue, this.valueFieldName);
        }
    }
}

