/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.session;

import java.nio.charset.StandardCharsets;
import kz.greetgo.security.crypto.Crypto;
import kz.greetgo.security.session.SaltGenerator;
import kz.greetgo.security.util.ByteUtil;
import org.bson.internal.Base64;

public class SaltGeneratorCryptoBridge
implements SaltGenerator {
    private final Crypto crypto;
    private final int saltLength;
    private final byte[] mixtureBytes;

    public SaltGeneratorCryptoBridge(Crypto crypto, int saltLength, byte[] mixtureBytes) {
        this.crypto = crypto;
        this.saltLength = saltLength;
        this.mixtureBytes = mixtureBytes;
    }

    @Override
    public String generateSalt(String str) {
        byte[] beginBytes = str.getBytes(StandardCharsets.UTF_8);
        byte[] sourceBytes = ByteUtil.xorBytes(beginBytes, ByteUtil.copyToLength(this.mixtureBytes, beginBytes.length));
        byte[] hashBytes = this.crypto.makeHash(sourceBytes);
        String salt = Base64.encode((byte[])hashBytes);
        salt = salt.replace('/', '$').replace('+', '~');
        while (salt.endsWith("=")) {
            salt = salt.substring(0, salt.length() - 1);
        }
        return this.saltLength > 0 && this.saltLength < salt.length() ? salt.substring(salt.length() - this.saltLength) : salt;
    }
}

