/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.session;

import java.security.SecureRandom;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kz.greetgo.security.errors.SerializedClassChanged;
import kz.greetgo.security.session.SessionId;
import kz.greetgo.security.session.SessionIdentity;
import kz.greetgo.security.session.SessionRow;
import kz.greetgo.security.session.SessionService;
import kz.greetgo.security.session.SessionServiceBuilder;
import kz.greetgo.security.session.cache.Cache;
import kz.greetgo.security.session.cache.CacheBuilder;

class SessionServiceImpl
implements SessionService {
    private final SessionServiceBuilder builder;
    private static final String ENG = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String DEG = "0123456789";
    private static final char[] ALL = ("ABCDEFGHIJKLMNOPQRSTUVWXYZ".toLowerCase() + "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toUpperCase() + "0123456789").toCharArray();
    private static final int ALL_LEN = ALL.length;
    private final Random random = new SecureRandom();
    final ConcurrentMap<String, SessionCache> sessionCacheMap = new ConcurrentHashMap<String, SessionCache>();
    final ConcurrentMap<String, String> removedSessionIds = new ConcurrentHashMap<String, String>();
    private final Cache<String, Date> lastTouchedCache;

    private String generateId(int length) {
        int[] randomIndexes = this.random.ints().limit(length).map(i -> i < 0 ? -i : i).map(i -> i % ALL_LEN).toArray();
        char[] chars = new char[length];
        for (int i2 = 0; i2 < length; ++i2) {
            chars[i2] = ALL[randomIndexes[i2]];
        }
        return new String(chars);
    }

    public SessionServiceImpl(SessionServiceBuilder builder) {
        this.builder = builder;
        this.lastTouchedCache = new CacheBuilder<String, Date>().loader(builder.storage::loadLastTouchedAt).refreshTimeoutSec(builder.lastTouchedCacheTimeoutSec).maxSize(builder.lastTouchedCacheSize).build();
    }

    @Override
    public Map<String, String> statisticsInfo() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("Sessions cache size", "" + this.sessionCacheMap.size());
        ret.put("Removed sessions map size", "" + this.removedSessionIds.size());
        return ret;
    }

    @Override
    public SessionIdentity createSession(Object sessionData) {
        String sessionIdPart = this.generateId(this.builder.sessionIdLength);
        String sessionSalt = this.builder.saltGenerator.generateSalt(sessionIdPart);
        String sessionId = new SessionId(sessionSalt, sessionIdPart).toString();
        String token = this.generateId(this.builder.tokenLength);
        SessionIdentity identity = new SessionIdentity(sessionId, token);
        this.builder.storage.insertSession(identity, sessionData);
        Date lastTouchedAt = this.loadLastTouchedAt(identity.id);
        SessionCache sessionCache = new SessionCache(sessionData, token, lastTouchedAt);
        this.sessionCacheMap.put(sessionId, sessionCache);
        return identity;
    }

    private Date loadLastTouchedAt(String sessionId) {
        return this.lastTouchedCache.get(sessionId);
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }

    @Override
    public <T> T getSessionData(String sessionId) {
        if (this.removedSessionIds.containsKey(sessionId)) {
            return null;
        }
        SessionCache sessionCache = (SessionCache)this.sessionCacheMap.get(sessionId);
        if (sessionCache != null) {
            return SessionServiceImpl.cast(sessionCache.sessionData);
        }
        return SessionServiceImpl.cast(this.loadSession(sessionId).map(row -> row.sessionData).orElse(null));
    }

    private Optional<SessionRow> loadSession(String sessionId) {
        try {
            SessionRow sessionRow = this.builder.storage.loadSession(sessionId);
            if (sessionRow == null) {
                return Optional.empty();
            }
            this.sessionCacheMap.put(sessionId, sessionRow.toCacheRecord());
            return Optional.of(sessionRow);
        }
        catch (SerializedClassChanged e) {
            return Optional.empty();
        }
    }

    @Override
    public boolean verifyId(String sessionId) {
        if (sessionId == null) {
            return false;
        }
        SessionId s = SessionId.parse(sessionId);
        if (s == null) {
            return false;
        }
        if (s.part == null || s.part.isEmpty()) {
            return false;
        }
        if (s.salt == null || s.salt.isEmpty()) {
            return false;
        }
        String saltExpected = this.builder.saltGenerator.generateSalt(s.part);
        return saltExpected.equals(s.salt);
    }

    @Override
    public boolean verifyToken(String sessionId, String token) {
        SessionCache cache = (SessionCache)this.sessionCacheMap.get(sessionId);
        if (cache != null) {
            return Objects.equals(cache.token, token);
        }
        return this.loadSession(sessionId).filter(row -> row.token != null && row.token.equals(token)).isPresent();
    }

    @Override
    public Optional<String> getToken(String sessionId) {
        SessionCache cache = (SessionCache)this.sessionCacheMap.get(sessionId);
        if (cache != null) {
            return Optional.ofNullable(cache.token);
        }
        return this.loadSession(sessionId).map(x -> x.token);
    }

    @Override
    public void zeroSessionAge(String sessionId) {
        if (!this.verifyId(sessionId)) {
            return;
        }
        if (this.zeroSessionAgeInCacheIfExists(sessionId)) {
            return;
        }
        if (!this.loadSession(sessionId).isPresent()) {
            return;
        }
        this.zeroSessionAgeInCacheIfExists(sessionId);
    }

    private boolean zeroSessionAgeInCacheIfExists(String sessionId) {
        SessionCache sessionCache = (SessionCache)this.sessionCacheMap.get(sessionId);
        if (sessionCache == null) {
            return false;
        }
        sessionCache.lastTouchedAt.set(new Date());
        return true;
    }

    @Override
    public void removeSession(String sessionId) {
        if (!this.verifyId(sessionId)) {
            return;
        }
        this.sessionCacheMap.remove(sessionId);
        this.builder.storage.remove(sessionId);
        this.removedSessionIds.put(sessionId, sessionId);
    }

    @Override
    public void removeOldSessions() {
        this.builder.storage.removeSessionsOlderThan(this.builder.oldSessionAgeInHours);
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).add(10, -this.builder.oldSessionAgeInHours);
        Set<String> removingIds = this.sessionCacheMap.entrySet().stream().filter(s -> ((SessionCache)s.getValue()).lastTouchedAt.get().before(calendar.getTime())).map(Map.Entry::getKey).collect(Collectors.toSet());
        removingIds.forEach(this.sessionCacheMap::remove);
        removingIds.forEach(id -> this.removedSessionIds.put((String)id, (String)id));
    }

    @Override
    public void syncCache() {
        HashSet removingIds = new HashSet();
        for (Map.Entry e : this.sessionCacheMap.entrySet()) {
            SessionRow sessionRow = this.builder.storage.loadSession((String)e.getKey());
            if (sessionRow == null) {
                removingIds.add(e.getKey());
                continue;
            }
            if (sessionRow.lastTouchedAt == null || sessionRow.lastTouchedAt.before(((SessionCache)e.getValue()).lastTouchedAt.get())) {
                this.builder.storage.setLastTouchedAt((String)e.getKey(), ((SessionCache)e.getValue()).lastTouchedAt.get());
                continue;
            }
            ((SessionCache)e.getValue()).lastTouchedAt.set(sessionRow.lastTouchedAt);
        }
        removingIds.forEach(this.sessionCacheMap::remove);
        removingIds.forEach(id -> this.removedSessionIds.put((String)id, (String)id));
    }

    static class SessionCache {
        final Object sessionData;
        final String token;
        final AtomicReference<Date> lastTouchedAt;

        public SessionCache(Object sessionData, String token, Date lastTouchedAt) {
            this.sessionData = sessionData;
            this.token = token;
            this.lastTouchedAt = new AtomicReference<Date>(lastTouchedAt);
        }
    }
}

