/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.session.cache;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;

public class Cache<Input extends Comparable<Input>, Output> {
    private final LongSupplier refreshTimeoutSec;
    private final IntSupplier maxSize;
    private final Function<Input, Output> loader;
    private final LongSupplier nowMillisSupplier;
    private final ConcurrentNavigableMap<TimeInput<Input>, TimeInput<Input>> set = new ConcurrentSkipListMap<TimeInput<Input>, TimeInput<Input>>();
    private final ConcurrentMap<Input, Dot<Output>> map = new ConcurrentHashMap<Input, Dot<Output>>();

    public Cache(LongSupplier refreshTimeoutSec, IntSupplier maxSize, Function<Input, Output> loader, LongSupplier nowMillisSupplier) {
        this.refreshTimeoutSec = refreshTimeoutSec;
        this.maxSize = maxSize;
        this.loader = loader;
        this.nowMillisSupplier = nowMillisSupplier;
    }

    private long nowMillis() {
        return this.nowMillisSupplier.getAsLong();
    }

    private long refreshTimeoutSec() {
        return this.refreshTimeoutSec.getAsLong();
    }

    private int maxSize() {
        return this.maxSize.getAsInt();
    }

    private Output load(Input input) {
        return this.loader.apply(input);
    }

    public void invalidateAll() {
        this.set.clear();
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    public Output get(Input input) {
        long nowMillis = this.nowMillis();
        Dot outputDot = (Dot)this.map.get(input);
        if (outputDot != null) {
            long timeMillis = outputDot.timeMillis;
            long refreshTimeoutMillis = this.refreshTimeoutSec() * 1000L;
            if (nowMillis - timeMillis <= refreshTimeoutMillis) {
                this.correctSize();
                return outputDot.output;
            }
            this.set.remove(new TimeInput(timeMillis, (Comparable)input, null));
        }
        Output output = this.load(input);
        Dot<Output> newOutputDot = new Dot<Output>(output, nowMillis);
        TimeInput timeInput = new TimeInput(nowMillis, (Comparable)input, null);
        this.map.put(input, newOutputDot);
        this.set.put(timeInput, timeInput);
        this.correctSize();
        return output;
    }

    private void correctSize() {
        int maxSize = this.maxSize();
        while (this.set.size() > maxSize) {
            TimeInput first = (TimeInput)this.set.keySet().pollFirst();
            if (first == null) {
                return;
            }
            this.map.remove(first.input);
        }
    }

    private static class Dot<Output> {
        final Output output;
        final long timeMillis;

        public Dot(Output output, long timeMillis) {
            this.output = output;
            this.timeMillis = timeMillis;
        }

        public String toString() {
            return "Dot{" + this.timeMillis + ": " + this.output + '}';
        }
    }

    private static class TimeInput<Input extends Comparable<Input>>
    implements Comparable<TimeInput<Input>> {
        final long timeMillis;
        final Input input;

        private TimeInput(long timeMillis, Input input) {
            this.timeMillis = timeMillis;
            this.input = input;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeInput timeInput = (TimeInput)o;
            return this.timeMillis == timeInput.timeMillis && Objects.equals(this.input, timeInput.input);
        }

        public int hashCode() {
            return Objects.hash(this.timeMillis, this.input);
        }

        @Override
        public int compareTo(TimeInput<Input> o) {
            if (this.timeMillis != o.timeMillis) {
                return this.timeMillis - o.timeMillis < 0L ? -1 : 1;
            }
            if (this.input == null) {
                return o.input == null ? 0 : -1;
            }
            if (o.input == null) {
                return 1;
            }
            return this.input.compareTo(o.input);
        }

        public String toString() {
            return "TimeInput{" + this.timeMillis + " : " + this.input + '}';
        }

        /* synthetic */ TimeInput(long x0, Comparable x1, 1 x2) {
            this(x0, x1);
        }
    }
}

