/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.crypto.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import kz.greetgo.db.Jdbc;
import kz.greetgo.security.crypto.ContentAccess;
import kz.greetgo.security.crypto.errors.SqlWrapper;
import kz.greetgo.security.crypto.jdbc.ContentNames;
import kz.greetgo.security.crypto.jdbc.DbDialect;

public class JdbcContentAccess
implements ContentAccess {
    private final Jdbc jdbc;
    private final ContentNames names;
    private final String createTableDdl;
    private final DbDialect dialect;

    public JdbcContentAccess(Jdbc jdbc, ContentNames names, String createTableDdl, DbDialect dialect) {
        this.jdbc = jdbc;
        this.names = names;
        this.createTableDdl = createTableDdl;
        this.dialect = dialect;
    }

    @Override
    public byte[] downloadBytes() {
        return (byte[])this.jdbc.execute(con -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    @Override
    public void uploadBytes(byte[] bytes) {
        this.jdbc.execute(con -> {
            try {
                if (bytes == null) {
                    this.delete(con);
                    return null;
                }
                if (this.update(con, bytes) > 0) {
                    return null;
                }
            }
            catch (SQLException e) {
                if (this.dialect.isNoTable(e)) {
                    this.createTable(con);
                }
                throw new SqlWrapper(e);
            }
            try {
                this.insert(con, bytes);
            }
            catch (SQLException e) {
                if (this.dialect.isRecordAlreadyExists(e)) {
                    this.update(con, bytes);
                }
                throw new SqlWrapper(e);
            }
            return null;
        });
    }

    private void delete(Connection con) throws SQLException {
        String sql = "delete from " + this.names.tableName + " where " + this.names.idFieldName + " = ?";
        try (PreparedStatement ps = con.prepareStatement(sql);){
            ps.setString(1, this.names.idValue);
            ps.executeUpdate();
        }
    }

    private void createTable(Connection con) throws SQLException {
        try (PreparedStatement ps = con.prepareStatement(this.createTableDdl);){
            ps.executeUpdate();
        }
    }

    private int update(Connection con, byte[] bytes) throws SQLException {
        String sql = "update " + this.names.tableName + " set " + this.names.valueFieldName + " = ? where " + this.names.idFieldName + " = ?";
        try (PreparedStatement ps = con.prepareStatement(sql);){
            ps.setBytes(1, bytes);
            ps.setString(2, this.names.idValue);
            int n = ps.executeUpdate();
            return n;
        }
    }

    private void insert(Connection con, byte[] bytes) throws SQLException {
        String sql = "insert into " + this.names.tableName + " (" + this.names.idFieldName + ", " + this.names.valueFieldName + ") values (?, ?)";
        try (PreparedStatement ps = con.prepareStatement(sql);){
            ps.setString(1, this.names.idValue);
            ps.setBytes(2, bytes);
            ps.executeUpdate();
        }
    }

    @Override
    public boolean exists() {
        return (Boolean)this.jdbc.execute(con -> {
            try {
                return this.checkExists(con);
            }
            catch (SQLException e) {
                if (this.dialect.isNoTable(e)) {
                    this.createTable(con);
                    return this.checkExists(con);
                }
                throw e;
            }
        });
    }

    /*
     * Exception decompiling
     */
    private Boolean checkExists(Connection con) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

