/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.crypto;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import kz.greetgo.security.crypto.ContentAccess;

public class FileContentAccess
implements ContentAccess {
    private final File file;

    public FileContentAccess(File file) {
        this.file = file;
    }

    @Override
    public byte[] downloadBytes() {
        try {
            return Files.readAllBytes(this.file.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void uploadBytes(byte[] bytes) {
        if (bytes == null) {
            this.file.delete();
            return;
        }
        try {
            this.file.getParentFile().mkdirs();
            Files.write(this.file.toPath(), bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }
}

