/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.crypto;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import kz.greetgo.security.crypto.ContentAccess;
import kz.greetgo.security.crypto.CryptoBuilderKeysInMongo;
import kz.greetgo.security.util.Base64Util;
import kz.greetgo.security.util.MongoUtil;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoContentAccess
implements ContentAccess {
    private final MongoCollection<Document> collection;
    private final CryptoBuilderKeysInMongo.Names names;

    public MongoContentAccess(MongoCollection<Document> collection, CryptoBuilderKeysInMongo.Names names) {
        this.collection = collection;
        this.names = names;
    }

    @Override
    public byte[] downloadBytes() {
        Document found = (Document)this.collection.find(Filters.eq((String)this.names.idFieldName, (Object)this.names.idValue)).limit(1).first();
        if (found == null) {
            return null;
        }
        return Base64Util.base64ToBytes(MongoUtil.toStr(found.get((Object)this.names.keyFieldName)));
    }

    @Override
    public void uploadBytes(byte[] bytes) {
        if (bytes == null) {
            this.removeBytes();
            return;
        }
        String base64 = Base64Util.bytesToBase64(bytes);
        Bson filter = Filters.eq((String)this.names.idFieldName, (Object)this.names.idValue);
        Document set = new Document();
        set.append(this.names.keyFieldName, (Object)base64);
        Document update = new Document();
        update.append("$set", (Object)set);
        UpdateOptions options = new UpdateOptions();
        options.upsert(true);
        this.collection.updateOne(filter, (Bson)update, options);
    }

    private void removeBytes() {
        this.collection.deleteOne(Filters.eq((String)this.names.idFieldName, (Object)this.names.idValue));
    }

    @Override
    public boolean exists() {
        return null != this.collection.find(Filters.eq((String)this.names.idFieldName, (Object)this.names.idValue)).limit(1).first();
    }
}

