/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.session;

import java.nio.charset.StandardCharsets;
import javax.xml.bind.DatatypeConverter;
import kz.greetgo.security.crypto.Crypto;
import kz.greetgo.security.session.SaltGenerator;

public class SaltGeneratorCryptoBridge
implements SaltGenerator {
    private final Crypto crypto;
    private final int saltLength;

    public SaltGeneratorCryptoBridge(Crypto crypto, int saltLength) {
        this.crypto = crypto;
        this.saltLength = saltLength;
    }

    @Override
    public String generateSalt(String str) {
        byte[] saltBytes = this.crypto.encrypt(str.getBytes(StandardCharsets.UTF_8));
        String salt = DatatypeConverter.printBase64Binary((byte[])saltBytes);
        salt = salt.replace('/', '$').replace('+', '~');
        salt = salt.substring(0, salt.length() - 1);
        return this.saltLength > 0 && this.saltLength < salt.length() ? salt.substring(0, this.saltLength) : salt;
    }
}

