/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.session;

import kz.greetgo.security.crypto.Crypto;
import kz.greetgo.security.session.SaltGenerator;
import kz.greetgo.security.session.SaltGeneratorCryptoBridge;
import kz.greetgo.security.session.SessionService;
import kz.greetgo.security.session.SessionServiceImpl;
import kz.greetgo.security.session.SessionStorage;

public class SessionServiceBuilder {
    SessionStorage storage;
    SaltGenerator saltGenerator;
    int oldSessionAgeInHours = 24;
    int sessionIdLength = 15;
    int tokenLength = 15;
    private boolean built = false;

    private SessionServiceBuilder() {
    }

    public static SessionServiceBuilder newBuilder() {
        return new SessionServiceBuilder();
    }

    public SessionServiceBuilder setStorage(SessionStorage storage) {
        this.checkBuilt();
        this.storage = storage;
        return this;
    }

    private void checkBuilt() {
        if (this.built) {
            throw new RuntimeException("Already built");
        }
    }

    public SessionServiceBuilder setSaltGenerator(SaltGenerator saltGenerator) {
        this.checkBuilt();
        this.saltGenerator = saltGenerator;
        return this;
    }

    public SessionServiceBuilder setSaltGeneratorOnCrypto(Crypto crypto, int saltLength) {
        this.checkBuilt();
        this.saltGenerator = new SaltGeneratorCryptoBridge(crypto, saltLength);
        return this;
    }

    public SessionServiceBuilder setOldSessionAgeInHours(int oldSessionAgeInHours) {
        this.checkBuilt();
        this.oldSessionAgeInHours = oldSessionAgeInHours;
        return this;
    }

    public SessionServiceBuilder setSessionIdLength(int sessionIdLength) {
        this.checkBuilt();
        this.sessionIdLength = sessionIdLength;
        return this;
    }

    public SessionServiceBuilder setTokenLength(int tokenLength) {
        this.checkBuilt();
        this.tokenLength = tokenLength;
        return this;
    }

    public SessionService build() {
        this.built = true;
        if (this.storage == null) {
            throw new RuntimeException("No sessionStorage");
        }
        if (this.saltGenerator == null) {
            throw new RuntimeException("No saltGenerator");
        }
        return new SessionServiceImpl(this);
    }
}

