/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.session;

import java.sql.SQLException;
import java.util.List;
import kz.greetgo.security.session.Serializer;
import kz.greetgo.security.session.SessionIdentity;
import kz.greetgo.security.session.SessionStorage;
import kz.greetgo.security.session.SessionStorageAdapterAbstract;
import kz.greetgo.security.session.SessionStorageJdbcBuilder;

class SessionStorageOracleAdapter
extends SessionStorageAdapterAbstract
implements SessionStorage {
    SessionStorageOracleAdapter(SessionStorageJdbcBuilder.Names names) {
        super(names);
    }

    @Override
    protected String checkTableExistsSql() {
        return "select " + this.names.id + " from " + this.names.tableName + " where rowNum = 1";
    }

    @Override
    protected String insertSessionSql(List<Object> sqlParams, SessionIdentity identity, Object sessionData) {
        sqlParams.add(identity.id);
        sqlParams.add(identity.token);
        sqlParams.add(Serializer.serialize(sessionData));
        return "insert into " + this.names.tableName + " (" + this.names.id + ", " + this.names.token + ", " + this.names.sessionData + ") values (?, ?, ?)";
    }

    @Override
    protected String createSessionTableSql() {
        return "create table " + this.names.tableName + " (  " + this.names.id + " varchar2(50) not null,  " + this.names.token + " varchar2(50),  " + this.names.sessionData + " blob,  " + this.names.insertedAt + " timestamp default current_timestamp not null ,  " + this.names.lastTouchedAt + " timestamp default current_timestamp not null,  primary key(" + this.names.id + "))";
    }

    @Override
    protected boolean isExceptionAboutTableDoesNotExists(SQLException sqlException) {
        return sqlException.getMessage().startsWith("ORA-00942:");
    }

    @Override
    protected String loadLastTouchedAtSql(List<Object> sqlParams, String sessionId) {
        sqlParams.add(sessionId);
        return "select " + this.names.lastTouchedAt + " from " + this.names.tableName + " where " + this.names.id + " = ?";
    }

    @Override
    protected String zeroSessionAgeSql(List<Object> sqlParams, String sessionId) {
        sqlParams.add(sessionId);
        return "update " + this.names.tableName + " set " + this.names.lastTouchedAt + " = current_timestamp where " + this.names.id + " = ?";
    }

    @Override
    protected String removeSessionsOlderThanSql(List<Object> sqlParams, int ageInHours) {
        return "delete from " + this.names.tableName + " where " + this.names.lastTouchedAt + " < current_timestamp - interval '" + ageInHours + "' hour";
    }
}

