/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.password;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kz.greetgo.security.password.PasswordEncoder;
import org.bson.internal.Base64;

public class PasswordEncoderBuilder {
    String salt = null;
    private boolean built = false;

    PasswordEncoderBuilder() {
    }

    public static PasswordEncoderBuilder newBuilder() {
        return new PasswordEncoderBuilder();
    }

    public PasswordEncoderBuilder setSalt(String salt) {
        this.checkBuilt();
        this.salt = salt;
        return this;
    }

    private void checkBuilt() {
        if (this.built) {
            throw new RuntimeException("Already built");
        }
    }

    public PasswordEncoder build() {
        if (this.salt == null) {
            throw new RuntimeException("Please, define salt calling method 'setSalt(...)'");
        }
        this.built = true;
        return new PasswordEncoder(){

            @Override
            public String encode(String password) {
                try {
                    MessageDigest digest = MessageDigest.getInstance("SHA-256");
                    digest.update(PasswordEncoderBuilder.this.salt.getBytes(StandardCharsets.UTF_8));
                    if (password != null) {
                        digest.update(password.getBytes(StandardCharsets.UTF_8));
                    }
                    String base64 = Base64.encode((byte[])digest.digest());
                    base64 = base64.replace('/', '$');
                    base64 = base64.replace('+', '~');
                    base64 = base64.substring(0, base64.length() - 1);
                    return base64;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public boolean verify(String password, String encodedPassword) {
                return this.encode(password).equals(encodedPassword);
            }
        };
    }
}

