/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.session;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import kz.greetgo.security.errors.SerializedClassChanged;
import kz.greetgo.security.util.Base64Util;

public class Serializer {
    public static byte[] serialize(Object object) {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bOut);
            out.writeObject(object);
            return bOut.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T deserialize(byte[] bytes) {
        try {
            if (bytes == null) {
                return null;
            }
            ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
            ObjectInputStream in = new ObjectInputStream(bIn);
            return (T)in.readObject();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvalidClassException e) {
            throw new SerializedClassChanged(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String serializeToStr(Object object) {
        return Base64Util.bytesToBase64(Serializer.serialize(object));
    }

    public static <T> T deserializeFromStr(String serializedStr) {
        return Serializer.deserialize(Base64Util.base64ToBytes(serializedStr));
    }
}

