/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.consumer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kz.greetgo.kafka.consumer.ParameterDefinition;
import kz.greetgo.kafka.consumer.ParameterValueValidator;
import kz.greetgo.kafka.consumer.ParameterValueValidatorInt;
import kz.greetgo.kafka.consumer.ParameterValueValidatorLong;
import kz.greetgo.kafka.consumer.ParameterValueValidatorStr;

public class ConsumerConfigDefaults {
    private final List<ParameterDefinition> parameterDefinitionList = new ArrayList<ParameterDefinition>();
    private final Map<String, ParameterDefinition> parameterDefinitionMap = new HashMap<String, ParameterDefinition>();
    private static final Map<String, ParameterValueValidator> validatorMap;
    private static final ParameterDefinition DEFAULT_PARAMETER_DEFINITION;

    public static ConsumerConfigDefaults withDefaults() {
        ConsumerConfigDefaults consumerConfigDefaults = new ConsumerConfigDefaults();
        consumerConfigDefaults.addDefaults();
        return consumerConfigDefaults;
    }

    public void addDefaults() {
        this.addDefinition(" Long   con.auto.commit.interval.ms           1000  ");
        this.addDefinition(" Long   con.session.timeout.ms               30000  ");
        this.addDefinition(" Long   con.heartbeat.interval.ms            10000  ");
        this.addDefinition(" Long   con.fetch.min.bytes                      1  ");
        this.addDefinition(" Long   con.max.partition.fetch.bytes      1048576  ");
        this.addDefinition(" Long   con.connections.max.idle.ms         540000  ");
        this.addDefinition(" Long   con.default.api.timeout.ms           60000  ");
        this.addDefinition(" Long   con.fetch.max.bytes               52428800  ");
        this.addDefinition(" Long   con.max.poll.interval.ms            300000  ");
        this.addDefinition(" Long   con.max.poll.records                   500  ");
        this.addDefinition(" Long   con.receive.buffer.bytes             65536  ");
        this.addDefinition(" Long   con.request.timeout.ms               30000  ");
        this.addDefinition(" Long   con.send.buffer.bytes               131072  ");
        this.addDefinition(" Long   con.fetch.max.wait.ms                  500  ");
        this.addDefinition(" Int out.worker.count        1  ");
        this.addDefinition(" Int out.poll.duration.ms  800  ");
    }

    public void addDefinition(String definitionStr) {
        String[] split = definitionStr.trim().split("\\s+");
        ParameterValueValidator validator = Objects.requireNonNull(validatorMap.get(split[0]));
        String parameterName = split[1];
        String defaultValue = split[2];
        ParameterDefinition definition = new ParameterDefinition(parameterName, defaultValue, validator);
        this.parameterDefinitionList.add(definition);
        this.parameterDefinitionMap.put(definition.parameterName, definition);
    }

    public List<ParameterDefinition> parameterDefinitionList() {
        return this.parameterDefinitionList;
    }

    public ParameterDefinition getDefinition(String parameterName) {
        Objects.requireNonNull(parameterName);
        ParameterDefinition pd = this.parameterDefinitionMap.get(parameterName);
        if (pd != null) {
            return pd;
        }
        return DEFAULT_PARAMETER_DEFINITION;
    }

    static {
        HashMap<String, ParameterValueValidator> vMap = new HashMap<String, ParameterValueValidator>();
        vMap.put("Long", new ParameterValueValidatorLong());
        vMap.put("Int", new ParameterValueValidatorInt());
        vMap.put("Str", new ParameterValueValidatorStr());
        validatorMap = Collections.unmodifiableMap(vMap);
        DEFAULT_PARAMETER_DEFINITION = new ParameterDefinition(null, "", new ParameterValueValidatorStr());
    }
}

