/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.consumer;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import kz.greetgo.kafka.consumer.ConsumerConfigDefaults;
import kz.greetgo.kafka.consumer.ConsumerConfigFileWorker;
import kz.greetgo.kafka.core.config.EventConfigFile;
import kz.greetgo.kafka.core.config.EventConfigFileFromStorage;
import kz.greetgo.kafka.core.config.EventConfigStorage;
import kz.greetgo.kafka.util.Handler;

public class ConsumerConfigWorker
implements AutoCloseable {
    private final Supplier<EventConfigStorage> configStorage;
    private final Handler configDataChanged;
    private final Supplier<ConsumerConfigDefaults> defaults;
    private String configPathPrefix;
    private String hostId;
    private final AtomicReference<ConsumerConfigFileWorker> worker = new AtomicReference<Object>(null);

    public void setConfigPathPrefix(String configPathPrefix) {
        this.checkNotStarted();
        this.configPathPrefix = configPathPrefix;
    }

    public void setHostId(String hostId) {
        this.checkNotStarted();
        this.hostId = hostId;
    }

    private void checkNotStarted() {
        if (this.worker.get() != null) {
            throw new RuntimeException("You cannot do it after worker has been started");
        }
    }

    public ConsumerConfigWorker(Supplier<EventConfigStorage> configStorage, Handler configDataChanged, Supplier<ConsumerConfigDefaults> defaults) {
        this.configStorage = configStorage;
        this.configDataChanged = configDataChanged;
        this.defaults = defaults;
    }

    public void start() {
        if (this.worker.get() != null) {
            return;
        }
        if (this.hostId == null) {
            throw new RuntimeException("Not defined hostId");
        }
        EventConfigFile parentConfig = this.eventConfigFileOn(this.configPathPrefix + ".conf");
        EventConfigFile parentConfigError = this.eventConfigFileOn(this.configPathPrefix + ".errors");
        EventConfigFile hostConfig = this.eventConfigFileOn(this.configPathPrefix + ".d/" + this.hostId + ".conf");
        EventConfigFile hostConfigError = this.eventConfigFileOn(this.configPathPrefix + ".d/" + this.hostId + ".errors");
        EventConfigFile hostConfigActualValues = this.eventConfigFileOn(this.configPathPrefix + ".d/" + this.hostId + ".actual-values");
        ConsumerConfigFileWorker worker2 = new ConsumerConfigFileWorker(this.configDataChanged, parentConfig, parentConfigError, hostConfig, hostConfigError, hostConfigActualValues, this.defaults);
        worker2.start();
        if (!this.worker.compareAndSet(null, worker2)) {
            worker2.close();
        }
    }

    private EventConfigFile eventConfigFileOn(String configPath) {
        return new EventConfigFileFromStorage(configPath, this.configStorage.get());
    }

    private ConsumerConfigFileWorker worker() {
        ConsumerConfigFileWorker ret = this.worker.get();
        if (ret == null) {
            throw new RuntimeException("You must start worker");
        }
        return ret;
    }

    @Override
    public void close() {
        ConsumerConfigFileWorker worker2 = this.worker.get();
        if (worker2 != null) {
            worker2.close();
        }
    }

    public int getWorkerCount() {
        return this.worker().getWorkerCount();
    }

    public Map<String, Object> getConfigMap() {
        return this.worker().getConfigMap();
    }

    public Duration pollDuration() {
        return this.worker().pollDuration();
    }
}

