/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.consumer;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kz.greetgo.kafka.consumer.AutoOffsetReset;
import kz.greetgo.kafka.consumer.Invoker;
import kz.greetgo.kafka.consumer.InvokerBuilder;
import kz.greetgo.kafka.consumer.annotations.ConsumersFolder;
import kz.greetgo.kafka.consumer.annotations.GroupId;
import kz.greetgo.kafka.consumer.annotations.KafkaNotifier;
import kz.greetgo.kafka.consumer.annotations.Topic;
import kz.greetgo.kafka.core.logger.Logger;
import kz.greetgo.kafka.util.AnnotationUtil;

public class ConsumerDefinition {
    private final Object controller;
    private final Method method;
    private final String folderPath;
    private final Invoker invoker;
    private final AutoOffsetReset autoOffsetReset;
    private final String groupId;

    public String toString() {
        return "ConsumerDefinition{" + this.controller.getClass() + "#" + this.method.getName() + ", folderPath=" + this.folderPath + ", groupId=" + this.groupId + '}';
    }

    public ConsumerDefinition(Object controller, Method method, Logger logger, String hostId) {
        this.controller = controller;
        this.method = method;
        ConsumersFolder consumersFolder = AnnotationUtil.getAnnotation(controller.getClass(), ConsumersFolder.class);
        this.folderPath = consumersFolder == null ? null : consumersFolder.value();
        this.invoker = new InvokerBuilder(controller, method, logger).build();
        this.autoOffsetReset = AnnotationUtil.getAnnotation(method, KafkaNotifier.class) == null ? AutoOffsetReset.EARLIEST : AutoOffsetReset.LATEST;
        GroupId annotation = AnnotationUtil.getAnnotation(method, GroupId.class);
        String tmpGroupId = annotation != null ? annotation.value() : method.getName();
        this.groupId = this.autoOffsetReset == AutoOffsetReset.EARLIEST ? tmpGroupId : tmpGroupId + hostId;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public Class<?> getControllerClass() {
        return this.getController().getClass();
    }

    public Object getController() {
        return this.controller;
    }

    public Method getMethod() {
        return this.method;
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    public String logDisplay() {
        StringBuilder sb = new StringBuilder();
        if (this.folderPath != null) {
            sb.append(this.folderPath).append("/");
        }
        sb.append(this.controller.getClass().getSimpleName());
        sb.append('.');
        String consumerName = this.getConsumerName();
        if (Objects.equals(consumerName, this.method.getName())) {
            sb.append('[').append(consumerName).append(']');
        } else {
            sb.append(this.method.getName()).append('[').append(consumerName).append(']');
        }
        return sb.toString();
    }

    public AutoOffsetReset getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public boolean isAutoCommit() {
        return this.invoker.isAutoCommit();
    }

    public String getConsumerName() {
        return this.invoker.getConsumerName();
    }

    public List<String> topicList() {
        Topic topic = AnnotationUtil.getAnnotation(this.method, Topic.class);
        if (topic == null) {
            throw new RuntimeException("No @" + Topic.class.getSimpleName() + " over " + this.method);
        }
        return Arrays.stream(topic.value()).collect(Collectors.toList());
    }

    public String getConfigPath() {
        String configName = this.getConsumerName();
        if (this.folderPath == null) {
            return configName;
        }
        return this.folderPath + "/" + configName;
    }
}

