/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.consumer.parameters;

import com.google.common.collect.Sets;
import java.util.Set;
import kz.greetgo.kafka.consumer.InnerProducerSender;
import kz.greetgo.kafka.consumer.InvokeSessionContext;
import kz.greetgo.kafka.consumer.ParameterValueReader;
import kz.greetgo.kafka.model.Box;
import kz.greetgo.kafka.producer.KafkaSending;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class InnerProducerSenderValueReader
implements ParameterValueReader {
    private String producerName;

    public InnerProducerSenderValueReader(String producerName) {
        this.producerName = producerName;
    }

    @Override
    public Set<String> getProducerNames() {
        return Sets.newHashSet((Object[])new String[]{this.producerName});
    }

    @Override
    public Object read(ConsumerRecord<byte[], Box> record, final InvokeSessionContext invokeSessionContext) {
        return new InnerProducerSender(){

            @Override
            public InnerProducerSender.Sending sending(final Object model) {
                return new InnerProducerSender.Sending(){
                    private final KafkaSending kafkaSending;
                    {
                        this.kafkaSending = invokeSessionContext.getProducer(InnerProducerSenderValueReader.this.producerName).sending(model);
                    }

                    @Override
                    public InnerProducerSender.Sending toTopic(String topic) {
                        this.kafkaSending.toTopic(topic);
                        return this;
                    }

                    @Override
                    public InnerProducerSender.Sending toPartition(int partition) {
                        this.kafkaSending.toPartition(partition);
                        return this;
                    }

                    @Override
                    public InnerProducerSender.Sending setTimestamp(Long timestamp) {
                        this.kafkaSending.setTimestamp(timestamp);
                        return this;
                    }

                    @Override
                    public InnerProducerSender.Sending addHeader(String key, byte[] value) {
                        this.kafkaSending.addHeader(key, value);
                        return this;
                    }

                    @Override
                    public InnerProducerSender.Sending addConsumerToIgnore(String consumerName) {
                        this.kafkaSending.addConsumerToIgnore(consumerName);
                        return this;
                    }

                    @Override
                    public InnerProducerSender.Sending setAuthor(String author) {
                        this.kafkaSending.setAuthor(author);
                        return this;
                    }

                    @Override
                    public void go() {
                        invokeSessionContext.kafkaFutures.add(this.kafkaSending.go());
                    }
                };
            }
        };
    }
}

