/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.consumer.parameters;

import com.google.common.collect.Sets;
import java.util.Set;
import kz.greetgo.kafka.consumer.InvokeSessionContext;
import kz.greetgo.kafka.consumer.ParameterValueReader;
import kz.greetgo.kafka.model.Box;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class InnerProducerValueReader
implements ParameterValueReader {
    private String producerName;
    private String topic;

    public InnerProducerValueReader(String producerName, String topic) {
        this.producerName = producerName;
        this.topic = topic;
    }

    @Override
    public Set<String> getProducerNames() {
        return Sets.newHashSet((Object[])new String[]{this.producerName});
    }

    @Override
    public Object read(ConsumerRecord<byte[], Box> record, InvokeSessionContext invokeSessionContext) {
        return model -> invokeSessionContext.kafkaFutures.add(invokeSessionContext.getProducer(this.producerName).sending(model).toTopic(this.topic).go());
    }
}

