/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import kz.greetgo.kafka.consumer.ConsumerDefinition;
import kz.greetgo.kafka.consumer.ConsumerDefinitionExtractor;
import kz.greetgo.kafka.consumer.ConsumerReactor;
import kz.greetgo.kafka.core.KafkaReactor;
import kz.greetgo.kafka.core.config.EventConfigStorage;
import kz.greetgo.kafka.core.logger.Logger;
import kz.greetgo.kafka.core.logger.LoggerExternal;
import kz.greetgo.kafka.errors.NotDefined;
import kz.greetgo.kafka.producer.ProducerFacade;
import kz.greetgo.kafka.producer.ProducerFacadeBridge;
import kz.greetgo.kafka.producer.ProducerSource;
import kz.greetgo.strconverter.StrConverter;

public abstract class KafkaReactorAbstract
implements KafkaReactor {
    protected Supplier<String> authorGetter;
    protected EventConfigStorage consumerConfigStorage;
    protected EventConfigStorage producerConfigStorage;
    protected String hostId;
    protected Supplier<String> bootstrapServers;
    protected final Logger logger = new Logger();
    protected final List<Object> controllerList = new ArrayList<Object>();
    private Supplier<StrConverter> strConverterSupplier;

    @Override
    public void setConsumerConfigStorage(EventConfigStorage consumerConfigStorage) {
        this.consumerConfigStorage = consumerConfigStorage;
    }

    @Override
    public void setProducerConfigStorage(EventConfigStorage producerConfigStorage) {
        this.producerConfigStorage = producerConfigStorage;
    }

    @Override
    public LoggerExternal logger() {
        return this.logger;
    }

    @Override
    public void setAuthorSupplier(Supplier<String> authorGetter) {
        this.authorGetter = authorGetter;
    }

    @Override
    public void setBootstrapServers(Supplier<String> bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    @Override
    public void addController(Object controller) {
        this.controllerList.add(controller);
    }

    protected Supplier<StrConverter> strConverterSupplier() {
        Supplier<StrConverter> ret = this.strConverterSupplier;
        if (ret == null) {
            throw new NullPointerException("strConverterSupplier == null");
        }
        return ret;
    }

    @Override
    public Optional<ConsumerReactor> consumer(String consumerName) {
        return Optional.empty();
    }

    @Override
    public void setStrConverterSupplier(Supplier<StrConverter> strConverterSupplier) {
        this.strConverterSupplier = strConverterSupplier;
    }

    @Override
    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    protected abstract ProducerSource getProducerSource();

    @Override
    public ProducerFacade createProducer(String producerName) {
        return ProducerFacadeBridge.createAutoResettableBridge(producerName, this.getProducerSource());
    }

    protected void verifyControllerList() {
        if (this.controllerList.isEmpty()) {
            throw new NotDefined("controllerList in " + this.getClass().getSimpleName());
        }
    }

    protected List<ConsumerDefinition> accumulateConsumerDefinitionList() {
        ArrayList<ConsumerDefinition> consumerDefinitionList = new ArrayList<ConsumerDefinition>();
        ConsumerDefinitionExtractor cde = new ConsumerDefinitionExtractor();
        cde.logger = this.logger;
        cde.hostId = this.hostId;
        for (Object controller : this.controllerList) {
            consumerDefinitionList.addAll(cde.extract(controller));
        }
        if (consumerDefinitionList.isEmpty()) {
            throw new NotDefined("Consumers in " + KafkaReactor.class.getSimpleName() + ".start()");
        }
        return consumerDefinitionList;
    }
}

