/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.core;

import java.util.List;
import kz.greetgo.kafka.model.Box;
import kz.greetgo.kafka.serializer.BoxSerializer;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.internals.DefaultPartitioner;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;

public class MockProducerHolder {
    private final String producerName;
    private final ByteArraySerializer keySerializer;
    private final BoxSerializer valueSerializer;
    private final Cluster cluster;
    private final Partitioner partitioner;
    private final MockProducer<byte[], Box> producer;

    public MockProducerHolder(String producerName, ByteArraySerializer keySerializer, BoxSerializer valueSerializer, Cluster cluster) {
        this.producerName = producerName;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.cluster = cluster == null ? Cluster.empty() : cluster;
        this.partitioner = new DefaultPartitioner();
        this.producer = new MockProducer(this.cluster, true, this.partitioner, (Serializer)keySerializer, (Serializer)valueSerializer);
    }

    public String getProducerName() {
        return this.producerName;
    }

    public MockProducer<byte[], Box> getProducer() {
        return this.producer;
    }

    public Partitioner getPartitioner() {
        return this.partitioner;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public TopicPartition topicPartition(ProducerRecord<byte[], Box> record) {
        int partition = 0;
        if (!this.cluster.partitionsForTopic(record.topic()).isEmpty()) {
            partition = this.partition(record, this.cluster);
        }
        return new TopicPartition(record.topic(), partition);
    }

    private int partition(ProducerRecord<byte[], Box> record, Cluster cluster) {
        Integer partition = record.partition();
        String topic = record.topic();
        if (partition != null) {
            List partitions = cluster.partitionsForTopic(topic);
            int numPartitions = partitions.size();
            if (partition < 0 || partition >= numPartitions) {
                throw new IllegalArgumentException("Invalid partition given with record: " + partition + " is not in the range [0..." + numPartitions + "].");
            }
            return partition;
        }
        byte[] keyBytes = this.keySerializer.serialize(topic, record.headers(), record.key());
        byte[] valueBytes = this.valueSerializer.serialize(topic, record.headers(), record.value());
        return this.partitioner.partition(topic, record.key(), keyBytes, record.value(), valueBytes, cluster);
    }
}

