/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.core.config;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kz.greetgo.kafka.consumer.ConsumerConfigDefaults;
import kz.greetgo.kafka.core.config.ConfigLine;
import kz.greetgo.kafka.util.StrUtil;

public class ConfigContent {
    private final Map<String, Supplier<Optional<String>>> valueSupplierMap;
    private final List<ConfigLine> lines;
    public final byte[] contentInBytes;

    public ConfigContent(ConsumerConfigDefaults defaults, byte[] contentInBytes) {
        this(defaults, contentInBytes, null);
    }

    public ConfigContent(ConsumerConfigDefaults defaults, byte[] contentInBytes, Supplier<ConfigContent> parent) {
        this.contentInBytes = contentInBytes;
        ArrayList<ConfigLine> lines = new ArrayList<ConfigLine>();
        HashMap<String, Supplier<Optional<String>>> valueSupplierMap = new HashMap<String, Supplier<Optional<String>>>();
        for (String lineStr : new String(contentInBytes, StandardCharsets.UTF_8).split("\n")) {
            ConfigLine line = ConfigLine.parse(defaults, lineStr);
            lines.add(line);
            if (line.key == null) continue;
            valueSupplierMap.put(line.key, line.createValueSupplier(parent));
        }
        this.lines = Collections.unmodifiableList(lines);
        this.valueSupplierMap = Collections.unmodifiableMap(valueSupplierMap);
    }

    public boolean parameterExists(String parameterName) {
        return this.valueSupplierMap.containsKey(parameterName);
    }

    public Map<String, Object> getConfigMap(String keyPrefix) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        List filteredNames = this.valueSupplierMap.keySet().stream().filter(x -> x.startsWith(keyPrefix)).collect(Collectors.toList());
        for (String filteredName : filteredNames) {
            Optional<String> optional = this.getStrValue(filteredName);
            if (!optional.isPresent()) continue;
            String nameWithoutPrefix = filteredName.substring(keyPrefix.length());
            ret.put(nameWithoutPrefix, optional.get());
        }
        return ret;
    }

    public Optional<Long> getLongValue(String parameterName) {
        return this.getStrValue(parameterName).map(StrUtil::parseLongOrNull);
    }

    public Optional<Integer> getIntValue(String parameterName) {
        return this.getStrValue(parameterName).map(StrUtil::parseIntOrNull);
    }

    public Optional<String> getStrValue(String parameterName) {
        if (parameterName == null) {
            return Optional.empty();
        }
        Supplier<Optional<String>> supplier = this.valueSupplierMap.get(parameterName);
        if (supplier == null) {
            return Optional.empty();
        }
        return supplier.get();
    }

    public byte[] generateActualValuesInBytes() {
        ArrayList lines = new ArrayList();
        for (ConfigLine line : this.lines) {
            Optional<String> opStrValue = this.getStrValue(line.key);
            opStrValue.ifPresent(strValue -> lines.add(line.key + " = " + strValue));
        }
        return String.join((CharSequence)"\n", lines).getBytes(StandardCharsets.UTF_8);
    }

    public byte[] generateErrorsInBytes() {
        ArrayList<String> lines = new ArrayList<String>();
        if (!this.getStrValue("out.worker.count").isPresent()) {
            lines.add("");
            lines.add("ERROR: Parameter `out.worker.count` is absent - using value `0`");
        }
        int lineNumber = 1;
        for (ConfigLine line : this.lines) {
            line.appendErrorsIfExists(lines, lineNumber);
            ++lineNumber;
        }
        if (lines.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)"\n", lines).getBytes(StandardCharsets.UTF_8);
    }
}

