/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.core.config;

import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import kz.greetgo.kafka.core.config.ConfigEventType;
import kz.greetgo.kafka.core.config.EventConfigFile;
import kz.greetgo.kafka.core.config.EventConfigStorage;
import kz.greetgo.kafka.core.config.EventFileHandler;
import kz.greetgo.kafka.core.config.EventRegistration;

public class EventConfigFileFromStorage
implements EventConfigFile {
    private final String path;
    private final EventConfigStorage storage;

    public EventConfigFileFromStorage(String path, EventConfigStorage storage) {
        this.path = path;
        this.storage = storage;
    }

    @Override
    public EventRegistration addEventHandler(EventFileHandler eventFileHandler) {
        return this.storage.addEventHandler((String pathArg, ConfigEventType type) -> {
            if (Objects.equals(pathArg, this.path)) {
                eventFileHandler.eventHappened(type);
            }
        });
    }

    @Override
    public void ensureLookingFor() {
        this.storage.ensureLookingFor(this.path);
    }

    @Override
    public Optional<Date> createdAt() {
        return this.storage.createdAt(this.path);
    }

    @Override
    public Optional<Date> lastModifiedAt() {
        return this.storage.lastModifiedAt(this.path);
    }

    @Override
    public byte[] readContent() {
        return this.storage.readContent(this.path);
    }

    @Override
    public void writeContent(byte[] content) {
        this.storage.writeContent(this.path, content);
    }

    @Override
    public void close() {
    }
}

