/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.core.config;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kz.greetgo.kafka.core.config.ConfigEventHandler;
import kz.greetgo.kafka.core.config.ConfigEventType;
import kz.greetgo.kafka.core.config.EventConfigStorage;
import kz.greetgo.kafka.core.config.EventRegistration;

public abstract class EventConfigStorageAbstract
implements EventConfigStorage {
    private final ConcurrentHashMap<Long, ConfigEventHandler> map = new ConcurrentHashMap();
    private final AtomicLong nextId = new AtomicLong(1L);

    @Override
    public EventRegistration addEventHandler(ConfigEventHandler configEventHandler) {
        long id = this.nextId.getAndIncrement();
        this.map.put(id, configEventHandler);
        return () -> this.map.remove(id);
    }

    protected void fireConfigEventHandler(String path, ConfigEventType type) {
        for (ConfigEventHandler configEventHandler : new ArrayList<ConfigEventHandler>(this.map.values())) {
            configEventHandler.configEventHappened(path, type);
        }
    }

    @Override
    public void close() {
        this.map.clear();
    }
}

