/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.core.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import kz.greetgo.kafka.core.config.ConfigEventType;
import kz.greetgo.kafka.core.config.EventConfigStorageAbstract;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.retry.RetryNTimes;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class EventConfigStorageZooKeeper
extends EventConfigStorageAbstract
implements AutoCloseable {
    private final Supplier<String> zookeeperServers;
    private final String rootPath;
    private final IntSupplier sessionTimeout;
    private final AtomicReference<ZooKeeper> zkHolder = new AtomicReference<Object>(null);
    private final AtomicReference<CuratorFramework> clientHolder = new AtomicReference<Object>(null);
    private final AtomicBoolean opened = new AtomicBoolean(true);
    private final ConcurrentHashMap<String, CuratorFramework> lookingForMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, byte[]> nodesData = new ConcurrentHashMap();

    public EventConfigStorageZooKeeper(String rootPath, Supplier<String> zookeeperServers, IntSupplier sessionTimeout) {
        this.zookeeperServers = zookeeperServers;
        this.rootPath = rootPath;
        this.sessionTimeout = sessionTimeout;
    }

    public void reset() {
        ZooKeeper current = this.zkHolder.getAndSet(null);
        if (current != null) {
            try {
                current.close();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if ((current = (CuratorFramework)this.clientHolder.getAndSet(null)) != null) {
            current.close();
        }
    }

    public CuratorFramework client() {
        if (!this.opened.get()) {
            throw new RuntimeException(this.getClass().getSimpleName() + " closed");
        }
        return this.clientHolder.accumulateAndGet(null, (current, ignore) -> current != null ? current : this.createClient());
    }

    private CuratorFramework createClient() {
        int sleepMsBetweenRetries = 100;
        int maxRetries = 3;
        RetryNTimes retryPolicy = new RetryNTimes(maxRetries, sleepMsBetweenRetries);
        CuratorFramework client = CuratorFrameworkFactory.newClient((String)this.zookeeperServers.get(), (int)this.sessionTimeout.getAsInt(), (int)25000, (RetryPolicy)retryPolicy);
        client.start();
        this.prepareWatchers(client);
        return client;
    }

    @Override
    public void close() {
        this.opened.set(false);
        this.reset();
    }

    private String slashRootPath() {
        if (this.rootPath == null) {
            return "/";
        }
        if (this.rootPath.startsWith("/")) {
            return this.rootPath;
        }
        return "/" + this.rootPath;
    }

    private String zNode(String path) {
        String slashPath;
        String string = path == null ? "/" : (slashPath = path.startsWith("/") ? path : "/" + path);
        if (this.rootPath == null) {
            return slashPath;
        }
        String slashRootPath = this.slashRootPath();
        if (slashRootPath.endsWith("/")) {
            return slashRootPath + slashPath.substring(1);
        }
        return slashRootPath + slashPath;
    }

    private String zNodeToPath(String zNode) {
        if (this.rootPath == null) {
            if (zNode == null || zNode.isEmpty()) {
                return null;
            }
            if (zNode.startsWith("/")) {
                return zNode.substring(1);
            }
            return zNode;
        }
        String slashRootPath = this.slashRootPath();
        if (zNode == null || zNode.isEmpty()) {
            return null;
        }
        if (slashRootPath.equals(zNode)) {
            return slashRootPath;
        }
        if (!zNode.startsWith(slashRootPath + "/")) {
            return null;
        }
        return zNode.substring(slashRootPath.length() + 1);
    }

    @Override
    public Optional<Date> createdAt(String path) {
        try {
            return Optional.ofNullable(this.client().checkExists().forPath(this.zNode(path))).map(Stat::getCtime).map(Date::new);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Optional<Date> lastModifiedAt(String path) {
        try {
            return Optional.ofNullable(this.client().checkExists().forPath(this.zNode(path))).map(Stat::getMtime).map(Date::new);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] readContent(String path) {
        CuratorFramework client = this.client();
        String zNode = this.zNode(path);
        try {
            client.checkExists().forPath(zNode);
            Stat stat = (Stat)client.checkExists().forPath(zNode);
            if (stat == null) {
                return null;
            }
            return (byte[])client.getData().forPath(zNode);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeContent(String path, byte[] content) {
        byte[] current = this.readContent(path);
        if (Arrays.equals(current, content)) {
            return;
        }
        CuratorFramework client = this.client();
        String zNode = this.zNode(path);
        try {
            if (content == null) {
                Stat stat = (Stat)client.checkExists().forPath(zNode);
                if (stat == null) {
                    return;
                }
                this.nodesData.remove(path);
                ((BackgroundPathable)client.delete().withVersion(stat.getVersion())).forPath(zNode);
            } else {
                Stat stat = (Stat)client.checkExists().forPath(zNode);
                if (stat == null) {
                    this.nodesData.put(path, content);
                    client.create().creatingParentContainersIfNeeded().forPath(zNode, content);
                } else {
                    this.nodesData.put(path, content);
                    ((BackgroundPathAndBytesable)client.setData().withVersion(stat.getVersion())).forPath(zNode, content);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (KeeperException.BadVersionException | KeeperException.NodeExistsException e) {
            this.writeContent(path, content);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void prepareWatchers(CuratorFramework newClient) {
        ArrayList zNodes = new ArrayList(this.lookingForMap.keySet());
        for (String zNode : zNodes) {
            this.installWatcherOn(newClient, zNode);
        }
    }

    private void installWatcherOn(CuratorFramework client, String zNode) {
        this.lookingForMap.put(zNode, client);
        try {
            ((BackgroundPathable)client.checkExists().usingWatcher(this::processEvent)).forPath(zNode);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ConfigEventType eventTypeToType(Watcher.Event.EventType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case NodeCreated: {
                return ConfigEventType.CREATE;
            }
            case NodeDataChanged: {
                return ConfigEventType.UPDATE;
            }
            case NodeDeleted: {
                return ConfigEventType.DELETE;
            }
        }
        return null;
    }

    @Override
    public void ensureLookingFor(String path) {
        String zNode;
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        CuratorFramework client = this.client();
        if (client == this.lookingForMap.get(zNode = this.zNode(path))) {
            return;
        }
        byte[] content = this.readContent(path);
        if (content == null) {
            this.nodesData.remove(path);
        } else {
            this.nodesData.put(path, content);
        }
        this.installWatcherOn(client, zNode);
    }

    private void processEvent(WatchedEvent event) {
        String zNode = event.getPath();
        String path = this.zNodeToPath(zNode);
        if (path == null) {
            return;
        }
        ConfigEventType eventType = EventConfigStorageZooKeeper.eventTypeToType(event.getType());
        if (eventType == null) {
            return;
        }
        if (this.opened.get() && this.lookingForMap.containsKey(zNode)) {
            this.installWatcherOn(this.client(), zNode);
        }
        this.fireConfigEventHandlerLocal(path, eventType);
    }

    private void fireConfigEventHandlerLocal(String path, ConfigEventType eventType) {
        if (eventType == ConfigEventType.CREATE || eventType == ConfigEventType.UPDATE) {
            byte[] current;
            byte[] cached;
            do {
                if ((current = this.readContent(path)) == null) {
                    return;
                }
                cached = this.nodesData.get(path);
                if (!Arrays.equals(current, cached)) continue;
                return;
            } while (!this.nodesData.replace(path, cached, current));
            this.fireConfigEventHandler(path, eventType);
            return;
        }
        if (eventType == ConfigEventType.DELETE) {
            while (true) {
                byte[] current;
                if ((current = this.readContent(path)) != null) {
                    return;
                }
                byte[] cached = this.nodesData.get(path);
                if (cached == null) {
                    return;
                }
                if (!this.nodesData.remove(path, cached)) continue;
                this.fireConfigEventHandler(path, eventType);
            }
        }
    }
}

