/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.core.logger;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import kz.greetgo.kafka.consumer.ConsumerDefinition;
import kz.greetgo.kafka.core.logger.LogMessageAcceptor;
import kz.greetgo.kafka.core.logger.LoggerDestination;
import kz.greetgo.kafka.core.logger.LoggerDestinationMessageBridge;
import kz.greetgo.kafka.core.logger.LoggerExternal;
import kz.greetgo.kafka.core.logger.LoggerType;

public class Logger
implements LoggerExternal {
    private LoggerDestination destination = null;
    private static final Predicate<LoggerType> SHOW_ALL = x -> true;
    private final AtomicReference<Predicate<LoggerType>> loggerTypeFilter = new AtomicReference<Predicate<LoggerType>>(SHOW_ALL);

    @Override
    public void setDestination(LoggerDestination destination) {
        this.destination = destination;
    }

    @Override
    public void setDestination(LogMessageAcceptor acceptor) {
        this.destination = acceptor == null ? null : LoggerDestinationMessageBridge.of(acceptor);
    }

    @Override
    public void setLoggerTypeFilter(Predicate<LoggerType> loggerTypeFilter) {
        if (loggerTypeFilter == null) {
            this.loggerTypeFilter.set(SHOW_ALL);
        } else {
            this.loggerTypeFilter.set(loggerTypeFilter);
        }
    }

    public boolean isShow(LoggerType loggerType) {
        if (this.destination == null) {
            return false;
        }
        return this.loggerTypeFilter.get().test(loggerType);
    }

    public void logProducerConfigOnCreating(String producerName, Map<String, Object> configMap) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logProducerConfigOnCreating(producerName, configMap);
        }
    }

    public void logProducerClosed(String producerName) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logProducerClosed(producerName);
        }
    }

    public void logConsumerStartWorker(ConsumerDefinition consumerDefinition, long workerId) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logConsumerStartWorker(consumerDefinition, workerId);
        }
    }

    public void logConsumerFinishWorker(ConsumerDefinition consumerDefinition, long workerId) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logConsumerFinishWorker(consumerDefinition, workerId);
        }
    }

    public void logConsumerErrorInMethod(Throwable throwable, String consumerName, Object controller, Method method) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logConsumerErrorInMethod(throwable, consumerName, controller, method);
        }
    }

    public void logConsumerWorkerConfig(ConsumerDefinition consumerDefinition, long workerId, Map<String, Object> configMap) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logConsumerWorkerConfig(consumerDefinition, workerId, configMap);
        }
    }

    public void logConsumerIllegalAccessExceptionInvokingMethod(IllegalAccessException e, String consumerName, Object controller, Method method) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logConsumerIllegalAccessExceptionInvokingMethod(e, consumerName, controller, method);
        }
    }

    public void logConsumerReactorRefresh(ConsumerDefinition consumerDefinition, int currentCount, int workerCount) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logConsumerReactorRefresh(consumerDefinition, currentCount, workerCount);
        }
    }

    public void logConsumerPollExceptionHappened(RuntimeException exception, ConsumerDefinition consumerDefinition) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logConsumerPollExceptionHappened(exception, consumerDefinition);
        }
    }

    public void logConsumerCommitSyncExceptionHappened(RuntimeException exception, ConsumerDefinition consumerDefinition) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logConsumerCommitSyncExceptionHappened(exception, consumerDefinition);
        }
    }

    public void logProducerCreated(String producerName) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logProducerCreated(producerName);
        }
    }

    public void logProducerValidationError(Throwable error) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logProducerValidationError(error);
        }
    }
}

