/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.core.logger;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Supplier;
import kz.greetgo.kafka.consumer.ConsumerDefinition;
import kz.greetgo.kafka.core.logger.LogMessageAcceptor;
import kz.greetgo.kafka.core.logger.LoggerDestination;

public class LoggerDestinationMessageBridge
implements LoggerDestination {
    private final LogMessageAcceptor acceptor;

    private LoggerDestinationMessageBridge(LogMessageAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    public static LoggerDestinationMessageBridge of(LogMessageAcceptor acceptor) {
        return new LoggerDestinationMessageBridge(acceptor);
    }

    @Override
    public void logProducerConfigOnCreating(String producerName, Map<String, Object> configMap) {
        if (this.acceptor.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Created producer `").append(producerName).append("` with config:");
            configMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(e -> sb.append("\n    ").append((String)e.getKey()).append(" = `").append(e.getValue()).append("`"));
            this.acceptor.info(sb.toString());
        }
    }

    @Override
    public void logProducerClosed(String producerName) {
        if (this.acceptor.isInfoEnabled()) {
            this.acceptor.info("Closed producer `" + producerName + "`");
        }
    }

    @Override
    public void logProducerCreated(String producerName) {
        if (this.acceptor.isInfoEnabled()) {
            this.acceptor.info("Created producer `" + producerName + "`");
        }
    }

    private static void appendStackTrace(StringBuilder sb, Throwable throwable) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            PrintStream printStream = new PrintStream((OutputStream)outputStream, false, "UTF-8");
            throwable.printStackTrace(printStream);
            printStream.flush();
            sb.append(outputStream.toString("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void logConsumerStartWorker(ConsumerDefinition consumerDefinition, long workerId) {
        if (this.acceptor.isInfoEnabled()) {
            this.acceptor.info("Started consumer worker `" + consumerDefinition.logDisplay() + "` with id = " + workerId + " in thread " + Thread.currentThread().getName());
        }
    }

    @Override
    public void logConsumerFinishWorker(ConsumerDefinition consumerDefinition, long workerId) {
        if (this.acceptor.isInfoEnabled()) {
            this.acceptor.info("Finished consumer worker `" + consumerDefinition.logDisplay() + "` with id = " + workerId);
        }
    }

    @Override
    public void debug(Supplier<String> message) {
        if (this.acceptor.isDebugEnabled()) {
            this.acceptor.debug(message.get());
        }
    }

    @Override
    public void logConsumerErrorInMethod(Throwable throwable, String consumerName, Object controller, Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append("Error in consumer `").append(consumerName).append("` of ").append(controller.getClass().getName()).append("#").append(method.getName()).append("() ").append(":\n");
        LoggerDestinationMessageBridge.appendStackTrace(sb, throwable);
        this.acceptor.error(sb.toString());
    }

    @Override
    public void logConsumerWorkerConfig(ConsumerDefinition consumerDefinition, long workerId, Map<String, Object> configMap) {
        if (!this.acceptor.isInfoEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Consumer worker config: consumer = `").append(consumerDefinition.logDisplay()).append("`, workerId = ").append(workerId).append("\n");
        configMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(e -> sb.append("\n    ").append((String)e.getKey()).append(" = `").append(e.getValue()).append("`"));
        this.acceptor.info(sb.toString());
    }

    @Override
    public void logConsumerIllegalAccessExceptionInvokingMethod(IllegalAccessException e, String consumerName, Object controller, Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append("IllegalAccessException invoking method in consumer `").append(consumerName).append("` in ").append(controller.getClass().getName()).append("#").append(method.getName()).append("() :\n");
        LoggerDestinationMessageBridge.appendStackTrace(sb, e);
        this.acceptor.error(sb.toString());
    }

    @Override
    public void logConsumerPollExceptionHappened(RuntimeException exception, ConsumerDefinition consumerDefinition) {
        StringBuilder sb = new StringBuilder();
        sb.append("Poll exception in consumer ").append(consumerDefinition.logDisplay()).append(":\n");
        LoggerDestinationMessageBridge.appendStackTrace(sb, exception);
        this.acceptor.error(sb.toString());
    }

    @Override
    public void logConsumerCommitSyncExceptionHappened(RuntimeException exception, ConsumerDefinition consumerDefinition) {
        StringBuilder sb = new StringBuilder();
        sb.append("CommitSync exception in consumer ").append(consumerDefinition.logDisplay()).append(":\n");
        LoggerDestinationMessageBridge.appendStackTrace(sb, exception);
        this.acceptor.error(sb.toString());
    }

    @Override
    public void logProducerValidationError(Throwable error) {
        StringBuilder sb = new StringBuilder();
        sb.append("Producer validation error:\n");
        LoggerDestinationMessageBridge.appendStackTrace(sb, error);
        this.acceptor.error(sb.toString());
    }

    @Override
    public void logConsumerReactorRefresh(ConsumerDefinition consumerDefinition, int currentCount, int workerCount) {
        if (!this.acceptor.isInfoEnabled()) {
            return;
        }
        this.acceptor.info("Refresh consumer : currentCount = " + currentCount + ", newCount = " + workerCount + "; " + consumerDefinition.logDisplay());
    }
}

