/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.producer;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kz.greetgo.kafka.errors.future.ExecutionExceptionWrapper;
import kz.greetgo.kafka.errors.future.InterruptedExceptionWrapper;
import kz.greetgo.kafka.errors.future.TimeoutExceptionWrapper;
import org.apache.kafka.clients.producer.RecordMetadata;

public class KafkaFuture {
    private final Future<RecordMetadata> source;

    public KafkaFuture(Future<RecordMetadata> source) {
        this.source = source;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.source.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.source.isCancelled();
    }

    public boolean isDone() {
        return this.source.isDone();
    }

    public RecordMetadata awaitAndGet() {
        try {
            return this.source.get();
        }
        catch (InterruptedException e) {
            throw new InterruptedExceptionWrapper(e);
        }
        catch (ExecutionException e) {
            throw new ExecutionExceptionWrapper(e);
        }
    }

    public RecordMetadata get(long timeout, TimeUnit unit) {
        try {
            return this.source.get(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new InterruptedExceptionWrapper(e);
        }
        catch (ExecutionException e) {
            throw new ExecutionExceptionWrapper(e);
        }
        catch (TimeoutException e) {
            throw new TimeoutExceptionWrapper(e);
        }
    }
}

