/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.producer;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kz.greetgo.kafka.core.config.ConfigEventType;
import kz.greetgo.kafka.core.config.EventConfigStorage;
import kz.greetgo.kafka.core.config.EventRegistration;
import kz.greetgo.kafka.util.ConfigLines;

public class ProducerConfigWorker {
    private final Supplier<EventConfigStorage> configStorage;
    private final Consumer<ConfigLines> putDefaultValues;
    private final ConcurrentHashMap<String, ConfigLines> configLinesMap = new ConcurrentHashMap();
    private final AtomicReference<EventRegistration> registration = new AtomicReference<Object>(null);
    private final ConcurrentHashMap<String, Long> configPathUpdateTimestampMap = new ConcurrentHashMap();

    public ProducerConfigWorker(Supplier<EventConfigStorage> configStorage, Consumer<ConfigLines> putDefaultValues) {
        this.configStorage = configStorage;
        this.putDefaultValues = putDefaultValues;
    }

    private String configPath(String producerName) {
        return producerName + ".txt";
    }

    public Map<String, Object> getConfigFor(String producerName) {
        String configPath = this.configPath(producerName);
        ConfigLines configLines = this.configLinesMap.computeIfAbsent(configPath, this::createConfigLinesAndSaveUpdateTimestamp);
        EventConfigStorage configStorage = this.configStorage.get();
        if (!configStorage.exists(configPath)) {
            configStorage.writeContent(configPath, configLines.toBytes());
        }
        configStorage.ensureLookingFor(configPath);
        this.ensureRegisteredHandler();
        return configLines.getWithPrefix("prod.");
    }

    private void ensureRegisteredHandler() {
        EventRegistration registration;
        if (this.registration.get() == null && !this.registration.compareAndSet(null, registration = this.configStorage.get().addEventHandler(this::configEventHappened))) {
            registration.unregister();
        }
    }

    public void close() {
        EventRegistration registration = this.registration.getAndSet(null);
        if (registration != null) {
            registration.unregister();
        }
    }

    private void configEventHappened(String configPath, ConfigEventType type) {
        if (type != ConfigEventType.UPDATE) {
            return;
        }
        for (String key : new ArrayList(this.configLinesMap.keySet())) {
            if (!Objects.equals(key, configPath)) continue;
            ConfigLines configLines = ConfigLines.fromBytes(this.configStorage.get().readContent(configPath), key);
            if (configLines == null) {
                this.configLinesMap.remove(key);
            } else {
                this.configLinesMap.put(key, configLines);
            }
            this.configPathUpdateTimestampMap.put(configPath, System.nanoTime());
        }
    }

    public long getConfigUpdateTimestamp(String producerName) {
        String configPath = this.configPath(producerName);
        Long timestamp = this.configPathUpdateTimestampMap.get(configPath);
        return timestamp == null ? 0L : timestamp;
    }

    private ConfigLines createConfigLinesAndSaveUpdateTimestamp(String configPath) {
        ConfigLines ret = this.createConfigLines(configPath);
        this.configPathUpdateTimestampMap.put(configPath, System.nanoTime());
        return ret;
    }

    private ConfigLines createConfigLines(String configPath) {
        byte[] configBytes = this.configStorage.get().exists(configPath) ? this.configStorage.get().readContent(configPath) : null;
        if (configBytes != null) {
            return ConfigLines.fromBytes(configBytes, configPath);
        }
        ConfigLines ret = new ConfigLines(configPath);
        this.putDefaultValues.accept(ret);
        return ret;
    }
}

