/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.util;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kz.greetgo.kafka.util.ConfigLine;
import kz.greetgo.kafka.util.ConfigLineCommand;
import kz.greetgo.kafka.util.StrUtil;
import kz.greetgo.kafka.util.ValueSelect;

public class ConfigLines {
    private String configPath;
    public ConfigLines parent = null;
    final List<ConfigLine> lines = new ArrayList<ConfigLine>();
    private final List<String> originLines = new ArrayList<String>();
    private final List<String> errors = new ArrayList<String>();

    private ConfigLines() {
    }

    public ConfigLines(String configPath) {
        this.configPath = configPath;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String errorPath() {
        return this.configPath + ".errors.txt";
    }

    public static ConfigLines fromBytes(byte[] bytes, String configPath) {
        if (bytes == null) {
            return null;
        }
        ConfigLines ret = new ConfigLines();
        ret.configPath = configPath;
        ret.setBytes(bytes);
        return ret;
    }

    public void setBytes(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes == null in ConfigLines.setBytes()");
        }
        this.lines.clear();
        this.lines.addAll(Arrays.stream(new String(bytes, StandardCharsets.UTF_8).split("\n")).map(ConfigLine::parse).collect(Collectors.toList()));
        this.originLines.clear();
        this.originLines.addAll(this.lines.stream().map(ConfigLine::line).collect(Collectors.toList()));
        this.errors.clear();
    }

    public byte[] toBytes() {
        return this.lines.stream().map(ConfigLine::line).collect(Collectors.joining("\n")).getBytes(StandardCharsets.UTF_8);
    }

    public String getValue(String key) {
        for (ConfigLine line : this.lines) {
            if (line.isCommented() || !Objects.equals(key, line.key())) continue;
            ConfigLineCommand command = line.command();
            if (command == null) {
                return line.value();
            }
            if (command == ConfigLineCommand.NULL) {
                return null;
            }
            if (command == ConfigLineCommand.INHERITS) {
                ConfigLines parent = this.parent;
                if (parent == null) {
                    line.addError("No parent in " + this.configPath);
                    return null;
                }
                return parent.getValue(key);
            }
            return null;
        }
        return null;
    }

    public boolean isModified() {
        int size = this.originLines.size();
        if (size != this.lines.size()) {
            return true;
        }
        for (int i = 0; i < size; ++i) {
            if (Objects.equals(this.originLines.get(i), this.lines.get(i).line())) continue;
            return true;
        }
        return false;
    }

    public void addValueVariant(String key, ValueSelect valueVariant) {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        int lastKey = -1;
        int lastDefined = -1;
        for (int i = 0; i < this.lines.size(); ++i) {
            ConfigLine line = this.lines.get(i);
            if (line.key() != null) {
                lastDefined = i;
            }
            if (!key.equals(line.key())) continue;
            lastKey = i;
            if (!line.isEqualTo(valueVariant)) continue;
            return;
        }
        if (lastKey >= 0) {
            ConfigLine lastKeyLine = this.lines.get(lastKey).copy();
            lastKeyLine.set(valueVariant);
            lastKeyLine.setCommented(true);
            this.lines.add(lastKey + 1, lastKeyLine);
            return;
        }
        if (lastDefined >= 0) {
            ConfigLine lastDefinedLine = this.lines.get(lastDefined).copy();
            lastDefinedLine.setKey(key);
            lastDefinedLine.set(valueVariant);
            lastDefinedLine.setCommented(true);
            this.lines.add(lastDefined + 1, lastDefinedLine);
            return;
        }
        this.lines.add(ConfigLine.parse("#" + key + " " + valueVariant.toString()));
    }

    public void putValue(String key, String value) {
        this.put(key, ValueSelect.of(value));
    }

    public void put(String key, ValueSelect valueSelect) {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        key = key.trim();
        this.addValueVariant(key, valueSelect);
        for (ConfigLine line : this.lines) {
            if (!key.equals(line.key())) continue;
            line.setCommented(!line.isEqualTo(valueSelect));
        }
    }

    public List<String> errors() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.errors.size() > 0) {
            ret.addAll(this.errors);
            ret.add("");
        }
        int lineNo = 0;
        for (ConfigLine line : this.lines) {
            ++lineNo;
            for (String lineError : line.errors()) {
                ret.add("LINE " + lineNo + " : " + lineError);
            }
        }
        return ret;
    }

    public boolean existsValueOrCommand(String key) {
        for (ConfigLine line : this.lines) {
            String lineKey;
            if (line.isCommented() || (lineKey = line.key()) == null || !lineKey.equals(key)) continue;
            return true;
        }
        return false;
    }

    public void putCommand(String key, ConfigLineCommand command) {
        this.put(key, ValueSelect.of(command));
    }

    public Set<String> keys() {
        HashSet<String> ret = new HashSet<String>();
        for (ConfigLine line : this.lines) {
            if (line.isCommented() || line.key() == null) continue;
            ret.add(line.key());
        }
        return ret;
    }

    public void ensureError(String error) {
        StrUtil.addIfAbsent(this.errors, error);
    }

    public int getValueAsInt(String key, int defaultValue) {
        for (ConfigLine line : this.lines) {
            if (!Objects.equals(key, line.key()) || line.isCommented()) continue;
            ConfigLineCommand command = line.command();
            if (command == null) {
                try {
                    return Integer.parseInt(line.value());
                }
                catch (NumberFormatException e) {
                    line.ensureError("Illegal int format for int parameter " + key + ", error message : " + e.getClass().getSimpleName() + " : " + e.getMessage());
                    return defaultValue;
                }
            }
            if (command == ConfigLineCommand.NULL) {
                line.ensureError("Null for int parameter " + key);
                return defaultValue;
            }
            if (command == ConfigLineCommand.INHERITS) {
                ConfigLines parent = this.parent;
                if (parent == null) {
                    line.ensureError("No extends for int parameter " + key);
                    return defaultValue;
                }
                return parent.getValueAsInt(key, defaultValue);
            }
            line.ensureError("Unknown command for reading int parameter " + key);
            return defaultValue;
        }
        this.ensureError("Not found int parameter " + key);
        return defaultValue;
    }

    public Map<String, Object> getWithPrefix(String keyPrefix) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (ConfigLine line : this.lines) {
            if (line.isCommented() || line.key() == null) continue;
            if (keyPrefix == null) {
                ret.put(line.key(), line.value());
                continue;
            }
            if (!line.key().startsWith(keyPrefix)) continue;
            ret.put(line.key().substring(keyPrefix.length()), line.value());
        }
        return ret;
    }
}

