/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;

public class NetUtil {
    public static boolean canConnectToAnyBootstrapServer(String bootstrapServers) {
        for (String hostPort : bootstrapServers.split(",")) {
            if (!NetUtil.canConnectTo(hostPort)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canConnectTo(String hostPort) {
        String[] split = hostPort.split(":");
        if (split.length != 2) {
            throw new IllegalArgumentException("hostPort must contain only one comma");
        }
        String host = split[0].trim();
        int port = Integer.parseInt(split[1].trim());
        try (Socket socket = new Socket(host, port);){
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write("1\r\n\r\n".getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
            InputStream inputStream = socket.getInputStream();
            inputStream.read();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            if (e instanceof ConnectException) {
                return false;
            }
            if (!(e instanceof UnknownHostException)) throw new RuntimeException(e);
            return false;
        }
    }
}

