/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.util;

import java.util.Objects;
import kz.greetgo.kafka.util.ConfigLineCommand;

public class ValueSelect {
    private final String value;
    private final ConfigLineCommand command;

    private ValueSelect(String value, ConfigLineCommand command) {
        this.value = value;
        this.command = command;
    }

    public static ValueSelect of(String value) {
        return value == null ? new ValueSelect(null, ConfigLineCommand.NULL) : new ValueSelect(value, null);
    }

    public static ValueSelect of(ConfigLineCommand command) {
        return command == null ? new ValueSelect(null, ConfigLineCommand.NULL) : new ValueSelect(null, command);
    }

    public String value() {
        return this.value;
    }

    public ConfigLineCommand command() {
        return this.command;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueSelect that = (ValueSelect)o;
        return Objects.equals(this.value, that.value) && this.command == that.command;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.command});
    }

    public String toString() {
        String value = this.value;
        if (value != null) {
            return "= " + value;
        }
        return ": " + this.command.name().toLowerCase();
    }
}

