/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.consumer;

import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import kz.greetgo.kafka.consumer.config.ConsumerConfigDefaults;
import kz.greetgo.kafka.consumer.config.ParameterDefinition;
import kz.greetgo.kafka.core.config.ConfigContent;
import kz.greetgo.kafka.core.config.ConfigEventType;
import kz.greetgo.kafka.core.config.EventConfigFile;
import kz.greetgo.kafka.core.config.EventRegistration;
import kz.greetgo.kafka.util.Handler;

public class ConsumerConfigFileWorker {
    private final Handler configDataChanged;
    private final EventConfigFile parentConfig;
    private final EventConfigFile parentConfigError;
    private final EventConfigFile hostConfig;
    private final EventConfigFile hostConfigError;
    private final EventConfigFile hostConfigActualValues;
    private final EventRegistration parentConfigEventRegistration;
    private final EventRegistration hostConfigEventRegistration;
    private final Supplier<ConsumerConfigDefaults> defaults;
    private final AtomicReference<ConfigContent> parentContent = new AtomicReference<Object>(null);
    private final AtomicReference<ConfigContent> hostContent = new AtomicReference<Object>(null);

    public ConsumerConfigFileWorker(Handler configDataChanged, EventConfigFile parentConfig, EventConfigFile parentConfigError, EventConfigFile hostConfig, EventConfigFile hostConfigError, EventConfigFile hostConfigActualValues, Supplier<ConsumerConfigDefaults> defaults) {
        this.configDataChanged = configDataChanged;
        this.parentConfig = parentConfig;
        this.parentConfigError = parentConfigError;
        this.hostConfig = hostConfig;
        this.hostConfigError = hostConfigError;
        this.hostConfigActualValues = hostConfigActualValues;
        this.parentConfigEventRegistration = parentConfig.addEventHandler(type -> {
            if (type == ConfigEventType.UPDATE) {
                this.parentConfigUpdated();
            }
        });
        this.hostConfigEventRegistration = hostConfig.addEventHandler(type -> {
            if (type == ConfigEventType.UPDATE) {
                this.hostConfigUpdated();
            }
        });
        this.defaults = defaults;
    }

    public int getWorkerCount() {
        return this.hostContent.get().getIntValue("out.worker.count").orElse(0);
    }

    public Map<String, Object> getConfigMap() {
        return this.hostContent.get().getConfigMap("con.");
    }

    public Duration pollDuration() {
        return Duration.ofMillis(this.hostContent.get().getLongValue("out.poll.duration.ms").orElse(800L));
    }

    public void close() {
        this.hostConfigEventRegistration.unregister();
        this.parentConfigEventRegistration.unregister();
    }

    private ConfigContent createParentConfigContent() {
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        for (ParameterDefinition pd : this.defaults.get().parameterDefinitionList()) {
            lines.add((CallSite)((Object)(pd.parameterName + " = " + pd.defaultValue)));
        }
        return new ConfigContent(this.defaults.get(), String.join((CharSequence)"\n", lines).getBytes(StandardCharsets.UTF_8));
    }

    private ConfigContent createHostConfigContent() {
        ConfigContent parent = this.parentContent.get();
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        for (ParameterDefinition pd : this.defaults.get().parameterDefinitionList()) {
            if (parent.parameterExists(pd.parameterName)) {
                lines.add((CallSite)((Object)(pd.parameterName + " : inherits")));
                continue;
            }
            lines.add((CallSite)((Object)(pd.parameterName + "=" + pd.defaultValue)));
        }
        return new ConfigContent(this.defaults.get(), String.join((CharSequence)"\n", lines).getBytes(StandardCharsets.UTF_8), this.parentContent::get);
    }

    public void start() {
        ConfigContent content;
        byte[] contentInBytes = this.parentConfig.readContent();
        if (contentInBytes != null) {
            content = new ConfigContent(this.defaults.get(), contentInBytes);
            this.parentContent.set(content);
            this.parentConfigError.writeContent(content.generateErrorsInBytes());
        } else {
            content = this.createParentConfigContent();
            this.parentContent.set(content);
            this.parentConfig.writeContent(content.contentInBytes);
            this.parentConfigError.delete();
        }
        this.parentConfig.ensureLookingFor();
        contentInBytes = this.hostConfig.readContent();
        if (contentInBytes != null) {
            content = new ConfigContent(this.defaults.get(), contentInBytes, this.parentContent::get);
            this.hostContent.set(content);
            this.hostConfigError.writeContent(content.generateErrorsInBytes());
            this.hostConfigActualValues.writeContent(content.generateActualValuesInBytes());
        } else {
            content = this.createHostConfigContent();
            this.hostConfigError.delete();
            this.hostContent.set(content);
            this.hostConfig.writeContent(content.contentInBytes);
            this.hostConfigActualValues.writeContent(content.generateActualValuesInBytes());
        }
        this.hostConfig.ensureLookingFor();
    }

    private void parentConfigUpdated() {
        byte[] contentInBytes = this.parentConfig.readContent();
        if (contentInBytes == null) {
            return;
        }
        ConfigContent content = new ConfigContent(this.defaults.get(), contentInBytes);
        this.parentContent.set(content);
        this.parentConfig.writeContent(content.contentInBytes);
        this.parentConfigError.writeContent(content.generateErrorsInBytes());
        this.configDataChanged.handle();
    }

    private void hostConfigUpdated() {
        byte[] contentInBytes = this.hostConfig.readContent();
        if (contentInBytes == null) {
            return;
        }
        ConfigContent content = new ConfigContent(this.defaults.get(), contentInBytes, this.parentContent::get);
        this.hostContent.set(content);
        this.hostConfig.writeContent(content.contentInBytes);
        this.hostConfigError.writeContent(content.generateErrorsInBytes());
        this.hostConfigActualValues.writeContent(content.generateActualValuesInBytes());
        this.configDataChanged.handle();
    }
}

