/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.consumer;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import kz.greetgo.kafka.consumer.AutoOffsetReset;
import kz.greetgo.kafka.consumer.BoxFilter;
import kz.greetgo.kafka.consumer.ConsumerDefinition;
import kz.greetgo.kafka.consumer.ConsumerFilter;
import kz.greetgo.kafka.consumer.CustomBoxConsumer;
import kz.greetgo.kafka.consumer.CustomBytesConsumer;
import kz.greetgo.kafka.consumer.CustomStrConsumer;
import kz.greetgo.kafka.consumer.InvokeSessionFactory;
import kz.greetgo.kafka.consumer.Profile;
import kz.greetgo.kafka.consumer.TopicsInProfile;
import kz.greetgo.kafka.consumer.annotations.TopicContentType;
import kz.greetgo.kafka.core.logger.Logger;

public class ConsumerDefinitionCustom
implements ConsumerDefinition {
    private final String name;
    private final List<String> topicList;
    private final String folderPath;
    private final String workerCountFileName;
    private final AutoOffsetReset autoOffsetReset;
    private final String groupId;
    private final String description;
    private final boolean isDirect;
    private final boolean ignoreKafka;
    private final TopicContentType topicContentType;
    private final Profile profile;
    private final Supplier<String> topicPrefix;
    private final InvokeSessionFactory invokeSessionFactory;

    public ConsumerDefinitionCustom(CustomBoxConsumer customConsumer, CustomStrConsumer customStrConsumer, CustomBytesConsumer customBytesConsumer, String name, List<String> topicList, String folderPath, String workerCountFileName, AutoOffsetReset autoOffsetReset, String groupId, String description, Logger logger, Supplier<String> topicPrefix, List<Class<?>> commitOnList, boolean isDirect, boolean ignoreKafka, ConsumerFilter consumerFilter, TopicContentType topicContentType, Profile profile) {
        int countDefined = 0;
        if (customConsumer != null) {
            ++countDefined;
        }
        if (customStrConsumer != null) {
            ++countDefined;
        }
        if (customBytesConsumer != null) {
            ++countDefined;
        }
        if (countDefined == 0) {
            throw new RuntimeException("7gi0h81nt0 :: One consumer MUST be defined");
        }
        if (countDefined > 2) {
            throw new RuntimeException("S376K9O0RK :: Only one consumer MAY be defined");
        }
        this.name = name;
        this.topicList = List.copyOf(topicList);
        this.topicContentType = topicContentType;
        this.folderPath = folderPath;
        this.workerCountFileName = workerCountFileName;
        this.autoOffsetReset = autoOffsetReset;
        this.groupId = groupId;
        this.description = description;
        this.isDirect = isDirect;
        this.ignoreKafka = ignoreKafka;
        this.profile = Objects.requireNonNull(profile, "6jTRI9BVB3 :: profile == null");
        this.topicPrefix = topicPrefix != null ? topicPrefix : () -> null;
        ConsumerDefinitionCustom consumerDefinition = this;
        BoxFilter boxFilter = (box, recordKey) -> consumerFilter.isInFilter(consumerDefinition, box, recordKey);
        this.invokeSessionFactory = InvokeSessionFactory.builderCustom().commitOnAll(commitOnList).customBoxConsumer(customConsumer).customStrConsumer(customStrConsumer).customBytesConsumer(customBytesConsumer).logger(logger).boxFilter(boxFilter).build();
    }

    @Override
    public Object id() {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFolderPath() {
        return this.folderPath;
    }

    @Override
    public InvokeSessionFactory getInvoker() {
        return this.invokeSessionFactory;
    }

    @Override
    public String logDisplay() {
        return "CUSTOM[" + this.name + "]";
    }

    @Override
    public AutoOffsetReset getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    @Override
    public String getGroupId() {
        String prefix = this.topicPrefix.get();
        return prefix == null ? this.groupId : prefix + this.groupId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isAutoCommit() {
        return false;
    }

    @Override
    public String getConsumerName() {
        return this.name;
    }

    @Override
    public Set<TopicsInProfile> topicList() {
        return Set.of(TopicsInProfile.of(this.topicList, this.profile));
    }

    @Override
    public Set<TopicsInProfile> prefixedTopicList() {
        return TopicsInProfile.prefixTopics(this.topicPrefix.get(), this.topicList());
    }

    @Override
    public String workerCountFileName() {
        return this.workerCountFileName;
    }

    @Override
    public boolean isDirect() {
        return this.isDirect;
    }

    @Override
    public boolean ignoreKafka() {
        return this.ignoreKafka;
    }

    @Override
    public TopicContentType topicContentType() {
        return this.topicContentType;
    }

    @Override
    public Profile profile() {
        return this.profile;
    }
}

