/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.consumer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import kz.greetgo.kafka.consumer.AutoOffsetReset;
import kz.greetgo.kafka.consumer.ConsumerDefinitionCustom;
import kz.greetgo.kafka.consumer.ConsumerFilter;
import kz.greetgo.kafka.consumer.CustomBoxConsumer;
import kz.greetgo.kafka.consumer.CustomBytesConsumer;
import kz.greetgo.kafka.consumer.CustomStrConsumer;
import kz.greetgo.kafka.consumer.Profile;
import kz.greetgo.kafka.consumer.annotations.TopicContentType;
import kz.greetgo.kafka.core.logger.Logger;
import kz.greetgo.kafka.util.Fnn;

public class ConsumerDefinitionCustomBuilder {
    private CustomBoxConsumer customConsumer;
    private CustomStrConsumer customStrConsumer;
    private CustomBytesConsumer customBytesConsumer;
    private final List<String> topicList = new ArrayList<String>();
    private String groupId;
    private String name;
    private String folderPath;
    private String workerCountFileName;
    private AutoOffsetReset autoOffsetReset;
    private String description;
    private Logger logger;
    private boolean isDirect;
    private boolean ignoreKafka;
    private ConsumerFilter consumerFilter = (x, y, z) -> true;
    private Supplier<String> topicPrefix;
    private boolean topicPrefixGot = false;
    private Profile profile = new Profile(null);
    private final List<Class<?>> commitOnClassList = new ArrayList();

    public ConsumerDefinitionCustomBuilder logger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public ConsumerDefinitionCustomBuilder customConsumer(CustomBoxConsumer customConsumer) {
        this.customConsumer = Objects.requireNonNull(customConsumer, "2whl73P1fl :: customConsumer == null");
        return this;
    }

    public void customStrConsumer(CustomStrConsumer customStrConsumer) {
        this.customStrConsumer = Objects.requireNonNull(customStrConsumer, "EhXb7lak33 :: customStrConsumer == null");
    }

    public void customBytesConsumer(CustomBytesConsumer customBytesConsumer) {
        this.customBytesConsumer = Objects.requireNonNull(customBytesConsumer, "oDiP55IznR :: customBytesConsumer == null");
    }

    public ConsumerDefinitionCustomBuilder topicPrefix(Supplier<String> topicPrefix) {
        this.topicPrefix = topicPrefix != null ? topicPrefix : () -> null;
        this.topicPrefixGot = true;
        return this;
    }

    public ConsumerDefinitionCustomBuilder commitOn(Class<?> errorClass) {
        this.commitOnClassList.add(errorClass);
        return this;
    }

    public ConsumerDefinitionCustomBuilder commitOnAll(Collection<Class<?>> errorClassAll) {
        errorClassAll.forEach(this::commitOn);
        return this;
    }

    public ConsumerDefinitionCustomBuilder topic(String topic) {
        this.topicList.add(topic);
        return this;
    }

    public ConsumerDefinitionCustomBuilder groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public ConsumerDefinitionCustomBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ConsumerDefinitionCustomBuilder profile(String profile) {
        this.profile = new Profile(profile);
        return this;
    }

    public ConsumerDefinitionCustomBuilder folderPath(String folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    public ConsumerDefinitionCustomBuilder workerCountFileName(String workerCountFileName) {
        this.workerCountFileName = workerCountFileName;
        return this;
    }

    public ConsumerDefinitionCustomBuilder autoOffsetReset(AutoOffsetReset autoOffsetReset) {
        this.autoOffsetReset = autoOffsetReset;
        return this;
    }

    public ConsumerDefinitionCustomBuilder description(String description) {
        this.description = description;
        return this;
    }

    public ConsumerDefinitionCustomBuilder consumerFilter(ConsumerFilter consumerFilter) {
        this.consumerFilter = Objects.requireNonNull(consumerFilter, "i94aySq67t :: consumerFilter == null");
        return this;
    }

    public ConsumerDefinitionCustomBuilder direct(boolean direct, boolean ignoreKafka) {
        this.isDirect = direct;
        this.ignoreKafka = ignoreKafka;
        return this;
    }

    public ConsumerDefinitionCustom build() {
        String name = Objects.requireNonNull(this.name, "name");
        String workerCountFileName = Fnn.fnn(this.workerCountFileName, name + ".workerCount");
        AutoOffsetReset autoOffsetReset = Objects.requireNonNull(this.autoOffsetReset, "autoOffsetReset");
        String groupId = Fnn.fnn(this.groupId, name);
        if (!this.topicPrefixGot) {
            throw new RuntimeException("fBQhDe1MrY :: Define topicPrefix");
        }
        return new ConsumerDefinitionCustom(this.customConsumer, this.customStrConsumer, this.customBytesConsumer, name, this.topicList, this.folderPath, workerCountFileName, autoOffsetReset, groupId, this.description, this.logger, this.topicPrefix, this.commitOnClassList, this.isDirect, this.ignoreKafka, this.consumerFilter, this.findTopicContentType(), this.profile);
    }

    @Nonnull
    private TopicContentType findTopicContentType() {
        TopicContentType topicContentType = null;
        int consumerCount = 0;
        if (this.customConsumer != null) {
            ++consumerCount;
            topicContentType = TopicContentType.BOX;
        }
        if (this.customStrConsumer != null) {
            ++consumerCount;
            topicContentType = TopicContentType.STR;
        }
        if (this.customBytesConsumer != null) {
            ++consumerCount;
            topicContentType = TopicContentType.BYTES;
        }
        if (topicContentType == null) {
            throw new RuntimeException("tbr15pZPuI :: No consumer function");
        }
        if (consumerCount > 1) {
            throw new RuntimeException("Y4drcYN7ja :: Too many consumer functions");
        }
        return topicContentType;
    }
}

