/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.consumer;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import kz.greetgo.kafka.consumer.ConsumerDefinitionOnController;
import kz.greetgo.kafka.consumer.ConsumerFilter;
import kz.greetgo.kafka.consumer.annotations.Topic;
import kz.greetgo.kafka.consumer.annotations.TopicListMethod;
import kz.greetgo.kafka.core.logger.Logger;
import kz.greetgo.kafka.util.AnnotationUtil;

public class ConsumerDefinitionExtractor {
    public final Logger logger;
    public final Supplier<String> consumerHostId;
    private final Supplier<String> topicPrefix;
    private final Function<Object, String> controllerToWorkerCountFileName;
    private final ConsumerFilter consumerFilter;

    public ConsumerDefinitionExtractor(Logger logger, Supplier<String> topicPrefix, Function<Object, String> controllerToWorkerCountFileName, Supplier<String> consumerHostId, ConsumerFilter consumerFilter) {
        this.logger = Objects.requireNonNull(logger, "PmUmkLm3Pg");
        this.topicPrefix = topicPrefix != null ? topicPrefix : () -> null;
        this.controllerToWorkerCountFileName = Objects.requireNonNull(controllerToWorkerCountFileName, "k98Yi33y9W");
        this.consumerHostId = Objects.requireNonNull(consumerHostId, "aDttPcjFQ3");
        this.consumerFilter = Objects.requireNonNull(consumerFilter, "WMCi8hGhqR");
    }

    public List<ConsumerDefinitionOnController> extract(Object controller) {
        ArrayList<ConsumerDefinitionOnController> ret = new ArrayList<ConsumerDefinitionOnController>();
        for (Method method : controller.getClass().getMethods()) {
            Topic topic = AnnotationUtil.getAnnotation(method, Topic.class);
            TopicListMethod topicListMethod = AnnotationUtil.getAnnotation(method, TopicListMethod.class);
            if (topic == null && topicListMethod == null) continue;
            ret.add(new ConsumerDefinitionOnController(controller, method, this.logger, this.topicPrefix, this.consumerHostId.get(), this.controllerToWorkerCountFileName.apply(controller), this.consumerFilter));
        }
        return ret;
    }
}

