/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.consumer;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import kz.greetgo.kafka.consumer.AutoOffsetReset;
import kz.greetgo.kafka.consumer.BoxFilter;
import kz.greetgo.kafka.consumer.ConsumerDefinition;
import kz.greetgo.kafka.consumer.ConsumerDirectStatus;
import kz.greetgo.kafka.consumer.ConsumerFilter;
import kz.greetgo.kafka.consumer.InvokeSessionFactory;
import kz.greetgo.kafka.consumer.Profile;
import kz.greetgo.kafka.consumer.TopicContentTypeReader;
import kz.greetgo.kafka.consumer.TopicsInProfile;
import kz.greetgo.kafka.consumer.annotations.ConsumerName;
import kz.greetgo.kafka.consumer.annotations.ConsumersFolder;
import kz.greetgo.kafka.consumer.annotations.Direct;
import kz.greetgo.kafka.consumer.annotations.GroupId;
import kz.greetgo.kafka.consumer.annotations.KafkaDescription;
import kz.greetgo.kafka.consumer.annotations.KafkaNotifier;
import kz.greetgo.kafka.consumer.annotations.KafkaProfile;
import kz.greetgo.kafka.consumer.annotations.Topic;
import kz.greetgo.kafka.consumer.annotations.TopicContentType;
import kz.greetgo.kafka.consumer.annotations.TopicListMethod;
import kz.greetgo.kafka.core.logger.Logger;
import kz.greetgo.kafka.util.AnnotationUtil;
import kz.greetgo.kafka.util.GroupIdUtil;
import kz.greetgo.kafka.util.KafkaTopicUtil;

public class ConsumerDefinitionOnController
implements ConsumerDefinition {
    private final Id id;
    private final Object controller;
    private final Method method;
    private final String folderPath;
    private final InvokeSessionFactory invokeSessionFactory;
    private final String groupId;
    private final String description;
    private final String consumerName;
    private final ConsumerDirectStatus consumerDirectStatus;
    private final Profile profile;
    private final Supplier<String> topicPrefix;
    private final List<String> topicList;
    private final Supplier<Set<TopicsInProfile>> topicDynamicSupplier;
    private final AutoOffsetReset autoOffsetReset;
    private final String workerCountFileName;
    private final TopicContentType topicContentType;

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.controller.getClass() + "#" + this.method.getName() + ", folderPath=" + this.folderPath + ", groupId=" + this.groupId + "}";
    }

    @Override
    public Object id() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    public ConsumerDefinitionOnController(@Nonnull Object controller, @Nonnull Method method, Logger logger, Supplier<String> topicPrefix, String consumerHostId, String workerCountFileName, ConsumerFilter consumerFilter) {
        this.workerCountFileName = workerCountFileName;
        this.id = new Id(controller.getClass(), method);
        this.controller = controller;
        this.method = method;
        this.topicPrefix = topicPrefix != null ? topicPrefix : () -> null;
        ConsumerFilter consumerFilterUse = consumerFilter != null ? consumerFilter : (x, y, z) -> true;
        ConsumersFolder consumersFolder = AnnotationUtil.getAnnotation(controller.getClass(), ConsumersFolder.class);
        this.folderPath = consumersFolder == null ? null : consumersFolder.value();
        KafkaDescription kd = AnnotationUtil.getAnnotation(method, KafkaDescription.class);
        this.description = kd == null ? null : kd.value();
        this.consumerDirectStatus = ConsumerDefinitionOnController.extractConsumerDirectStatus(AnnotationUtil.getAnnotation(method, Direct.class), controller);
        String tmpConsumerName = method.getName();
        ConsumerName annotation = AnnotationUtil.getAnnotation(method, ConsumerName.class);
        if (annotation != null) {
            tmpConsumerName = annotation.value();
        }
        this.consumerName = tmpConsumerName;
        ConsumerDefinitionOnController consumerDefinition = this;
        BoxFilter boxFilter = (box, recordKey) -> consumerFilterUse.isInFilter(consumerDefinition, box, recordKey);
        this.invokeSessionFactory = InvokeSessionFactory.builderController(controller, method, logger, boxFilter, topicPrefix).build();
        this.autoOffsetReset = AnnotationUtil.getAnnotation(method, KafkaNotifier.class) == null ? AutoOffsetReset.EARLIEST : AutoOffsetReset.LATEST;
        GroupId annotation2 = AnnotationUtil.getAnnotation(method, GroupId.class);
        String tmpGroupId = annotation2 != null ? GroupIdUtil.evalGroupId(annotation2.value(), controller) : method.getName();
        this.groupId = this.autoOffsetReset == AutoOffsetReset.EARLIEST ? tmpGroupId : tmpGroupId + consumerHostId;
        Topic topic = AnnotationUtil.getAnnotation(method, Topic.class);
        this.topicList = topic == null ? List.of() : Arrays.stream(topic.value()).collect(Collectors.toUnmodifiableList());
        KafkaProfile ann = AnnotationUtil.getAnnotation(method, KafkaProfile.class);
        this.profile = new Profile(ann == null ? null : ann.value());
        TopicListMethod topicListMethod = AnnotationUtil.getAnnotation(method, TopicListMethod.class);
        if (topicListMethod == null) {
            this.topicDynamicSupplier = Set::of;
        } else {
            Method listTopicMethod;
            try {
                listTopicMethod = controller.getClass().getMethod(topicListMethod.value(), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("1DjZAwUFaI", e);
            }
            this.topicDynamicSupplier = () -> KafkaTopicUtil.callAndPrepareResult(this.profile, listTopicMethod, controller);
        }
        this.topicContentType = TopicContentTypeReader.readFrom(method);
    }

    @Nonnull
    private static ConsumerDirectStatus extractConsumerDirectStatus(Direct direct, Object controller) {
        if (direct == null) {
            return ConsumerDirectStatus.of(false, false);
        }
        if (direct.fromMethod().isEmpty()) {
            return ConsumerDirectStatus.of(true, direct.ignoreKafka());
        }
        try {
            Method method = controller.getClass().getMethod(direct.fromMethod(), new Class[0]);
            Object result = method.invoke(controller, new Object[0]);
            if (result instanceof ConsumerDirectStatus) {
                return (ConsumerDirectStatus)result;
            }
            throw new RuntimeException("HHtvY6ONj9 :: Method " + controller.getClass().getSimpleName() + "." + method.getName() + "() MUST returns " + ConsumerDirectStatus.class.getSimpleName() + ". Full name of method: " + method);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getFolderPath() {
        return this.folderPath;
    }

    public Object getController() {
        return this.controller;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public InvokeSessionFactory getInvoker() {
        return this.invokeSessionFactory;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String logDisplay() {
        StringBuilder sb = new StringBuilder();
        if (this.folderPath != null) {
            sb.append(this.folderPath).append("/");
        }
        sb.append(ConsumerDefinitionOnController.cutAfter$$(this.controller.getClass().getSimpleName()));
        sb.append('.');
        String consumerName = this.getConsumerName();
        if (Objects.equals(consumerName, this.method.getName())) {
            sb.append('[').append(consumerName).append(']');
        } else {
            sb.append(this.method.getName()).append('[').append(consumerName).append(']');
        }
        return sb.toString();
    }

    private static String cutAfter$$(String str) {
        if (str == null) {
            return null;
        }
        int idx = str.indexOf("$$");
        if (idx < 0) {
            return str;
        }
        return str.substring(0, idx);
    }

    @Override
    public AutoOffsetReset getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    @Override
    public String getGroupId() {
        String prefix = this.topicPrefix.get();
        return prefix == null ? this.groupId : prefix + this.groupId;
    }

    @Override
    public boolean isAutoCommit() {
        return false;
    }

    @Override
    public String getConsumerName() {
        return this.consumerName;
    }

    @Override
    public Set<TopicsInProfile> topicList() {
        HashSet<TopicsInProfile> topics = new HashSet<TopicsInProfile>();
        topics.add(TopicsInProfile.of(this.topicList, this.profile));
        topics.addAll((Collection)this.topicDynamicSupplier.get());
        return TopicsInProfile.distinct(topics);
    }

    @Override
    public Set<TopicsInProfile> prefixedTopicList() {
        return TopicsInProfile.prefixTopics(this.topicPrefix.get(), this.topicList());
    }

    @Override
    public String workerCountFileName() {
        return this.workerCountFileName;
    }

    @Override
    public boolean isDirect() {
        return this.consumerDirectStatus.isDirect;
    }

    @Override
    public boolean ignoreKafka() {
        return this.consumerDirectStatus.ignoreKafka;
    }

    @Override
    public TopicContentType topicContentType() {
        return this.topicContentType;
    }

    @Override
    public Profile profile() {
        return this.profile;
    }

    public static class Id {
        public final Class<?> controllerClass;
        public final Method method;

        private Id(Class<?> controllerClass, Method method) {
            this.controllerClass = controllerClass;
            this.method = method;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Id id = (Id)o;
            return Objects.equals(this.controllerClass, id.controllerClass) && Objects.equals(this.method, id.method);
        }

        public int hashCode() {
            return Objects.hash(this.controllerClass, this.method);
        }
    }
}

