/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.consumer;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import kz.greetgo.kafka.consumer.ConsumerDefinition;
import kz.greetgo.kafka.consumer.ConsumerReactor;
import kz.greetgo.kafka.consumer.ConsumerReactorImpl;
import kz.greetgo.kafka.consumer.config.ConsumerConnectSetter;
import kz.greetgo.kafka.consumer.config.ConsumerReactorConfig;
import kz.greetgo.kafka.core.ProducerSynchronizer;
import kz.greetgo.kafka.core.logger.Logger;
import kz.greetgo.strconverter.StrConverter;

public class ConsumerReactorBuilder {
    private Logger logger;
    private ProducerSynchronizer producerSynchronizer;
    private Supplier<StrConverter> strConverter;
    private ConsumerDefinition consumerDefinition;
    private Supplier<String> consumerThreadPrefix = () -> "kafka-consumer-";
    private ConsumerReactorConfig consumerConfig;
    private BooleanSupplier externalWorkingSupplier = () -> true;
    private ConsumerConnectSetter consumerConnectSetter;

    ConsumerReactorBuilder() {
    }

    public ConsumerReactorBuilder consumerConfig(ConsumerReactorConfig consumerConfig) {
        this.consumerConfig = Objects.requireNonNull(consumerConfig);
        return this;
    }

    public ConsumerReactorBuilder logger(Logger logger) {
        this.logger = Objects.requireNonNull(logger);
        return this;
    }

    public ConsumerReactorBuilder producerSynchronizer(ProducerSynchronizer producerSynchronizer) {
        this.producerSynchronizer = Objects.requireNonNull(producerSynchronizer);
        return this;
    }

    public ConsumerReactorBuilder strConverter(Supplier<StrConverter> strConverter) {
        this.strConverter = Objects.requireNonNull(strConverter);
        return this;
    }

    public ConsumerReactorBuilder consumerDefinition(ConsumerDefinition consumerDefinition) {
        this.consumerDefinition = Objects.requireNonNull(consumerDefinition);
        return this;
    }

    public ConsumerReactorBuilder consumerConnectSetter(ConsumerConnectSetter consumerConnectSetter) {
        this.consumerConnectSetter = consumerConnectSetter;
        return this;
    }

    public ConsumerReactorBuilder consumerThreadPrefix(Supplier<String> consumerThreadPrefix) {
        this.consumerThreadPrefix = Objects.requireNonNull(consumerThreadPrefix);
        return this;
    }

    public ConsumerReactorBuilder externalWorkingSupplier(BooleanSupplier workingSupplier) {
        this.externalWorkingSupplier = Objects.requireNonNull(workingSupplier);
        return this;
    }

    public ConsumerReactor build() {
        ConsumerReactorImpl reactor = new ConsumerReactorImpl();
        reactor.logger = Objects.requireNonNull(this.logger);
        reactor.producerSynchronizer = Objects.requireNonNull(this.producerSynchronizer);
        reactor.strConverter = Objects.requireNonNull(this.strConverter);
        reactor.consumerDefinition = Objects.requireNonNull(this.consumerDefinition);
        reactor.consumerConnectSetter = Objects.requireNonNull(this.consumerConnectSetter);
        reactor.consumerConfig = Objects.requireNonNull(this.consumerConfig);
        reactor.consumerThreadPrefix = Objects.requireNonNull(this.consumerThreadPrefix);
        reactor.externalWorkingSupplier = Objects.requireNonNull(this.externalWorkingSupplier);
        return reactor;
    }
}

