/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.consumer;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import kz.greetgo.kafka.consumer.BoxFilter;
import kz.greetgo.kafka.consumer.InvokeResult;
import kz.greetgo.kafka.consumer.InvokeSessionContext;
import kz.greetgo.kafka.consumer.InvokeSessionFactory;
import kz.greetgo.kafka.consumer.InvokeSessionFactoryImpl;
import kz.greetgo.kafka.consumer.Invoker;
import kz.greetgo.kafka.consumer.ParameterValueReader;
import kz.greetgo.kafka.consumer.Profile;
import kz.greetgo.kafka.consumer.TopicContentTypeReader;
import kz.greetgo.kafka.consumer.annotations.Author;
import kz.greetgo.kafka.consumer.annotations.KafkaCommitOn;
import kz.greetgo.kafka.consumer.annotations.KafkaId;
import kz.greetgo.kafka.consumer.annotations.Offset;
import kz.greetgo.kafka.consumer.annotations.Partition;
import kz.greetgo.kafka.consumer.annotations.ProfileRef;
import kz.greetgo.kafka.consumer.annotations.Timestamp;
import kz.greetgo.kafka.consumer.annotations.TopicContentType;
import kz.greetgo.kafka.consumer.annotations.TopicRef;
import kz.greetgo.kafka.core.logger.Logger;
import kz.greetgo.kafka.core.logger.LoggerType;
import kz.greetgo.kafka.errors.IllegalParameterType;
import kz.greetgo.kafka.model.Box;
import kz.greetgo.kafka.serializer.DeserializerError;
import kz.greetgo.kafka.util.AnnotationUtil;
import kz.greetgo.kafka.util.GenericUtil;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class InvokeSessionFactoryControllerBuilder {
    private final Object controller;
    private final Method method;
    private final Logger logger;
    private final BoxFilter boxFilter;
    private final Supplier<String> topicPrefix;

    public InvokeSessionFactoryControllerBuilder(Object controller, Method method, Logger logger, BoxFilter boxFilter, Supplier<String> topicPrefix) {
        this.controller = Objects.requireNonNull(controller, "wz6NF2lB8o :: controller == null");
        this.method = Objects.requireNonNull(method, "nC5a0z8Lzk :: method == null");
        this.logger = Objects.requireNonNull(logger, "gT11yHPpFL :: logger == null");
        this.boxFilter = Objects.requireNonNull(boxFilter, "5aAoiDzs48 :: boxFilter == null");
        this.topicPrefix = topicPrefix != null ? topicPrefix : () -> null;
    }

    public InvokeSessionFactory build() {
        Class[] tmpCommitOn = new Class[]{};
        final Class[] commitOn = AnnotationUtil.getAnnotation(this.method, KafkaCommitOn.class);
        if (commitOn != null) {
            tmpCommitOn = commitOn.value();
        }
        commitOn = tmpCommitOn;
        final TopicContentType topicContentType = TopicContentTypeReader.readFrom(this.method);
        Type[] parameterTypes = this.method.getGenericParameterTypes();
        Annotation[][] parameterAnnotations = AnnotationUtil.getParameterAnnotations(this.method);
        assert (parameterTypes.length == parameterAnnotations.length);
        final boolean[] canAcceptDeserializerError = new boolean[]{false};
        ParameterReaderOptions parameterReaderOptions = () -> {
            canAcceptDeserializerError[0] = true;
        };
        final int parametersCount = parameterTypes.length;
        final ParameterValueReader[] parameterValueReaders = new ParameterValueReader[parametersCount];
        for (int i = 0; i < parametersCount; ++i) {
            parameterValueReaders[i] = this.createParameterValueReader(parameterTypes[i], parameterAnnotations[i], topicContentType, parameterReaderOptions);
        }
        Class<?> tmpGettingBodyClass = null;
        for (ParameterValueReader parameterValueReader : parameterValueReaders) {
            Class<?> aClass = parameterValueReader.gettingBodyClass();
            if (aClass == null) continue;
            tmpGettingBodyClass = aClass;
        }
        final Class<?> gettingBodyClass = tmpGettingBodyClass;
        Invoker invoker = new Invoker(){

            @Override
            public InvokeResult invoke(@Nonnull ConsumerRecord<byte[], Object> record, @Nonnull InvokeSessionContext context, @Nonnull Profile profile) {
                if (!canAcceptDeserializerError[0] && record.value() instanceof DeserializerError) {
                    return InvokeResult.ok();
                }
                Object[] parameters = new Object[parametersCount];
                for (int i = 0; i < parametersCount; ++i) {
                    parameters[i] = parameterValueReaders[i].read(record, context, profile);
                }
                return this.invokeMethod(parameters, profile);
            }

            private boolean isInFilterBox(ConsumerRecord<byte[], Object> record) {
                Object recordValue = record.value();
                if (recordValue == null) {
                    return false;
                }
                if (!(recordValue instanceof Box)) {
                    return false;
                }
                Box box = (Box)recordValue;
                if (gettingBodyClass == null) {
                    return InvokeSessionFactoryControllerBuilder.this.boxFilter.isInFilter(box, (byte[])record.key());
                }
                if (gettingBodyClass == Box.class) {
                    return InvokeSessionFactoryControllerBuilder.this.boxFilter.isInFilter(box, (byte[])record.key());
                }
                if (!gettingBodyClass.isInstance(box.body)) {
                    return false;
                }
                return InvokeSessionFactoryControllerBuilder.this.boxFilter.isInFilter(box, (byte[])record.key());
            }

            private boolean isInFilterStr(ConsumerRecord<byte[], Object> record) {
                return record.value() instanceof String;
            }

            private boolean isInFilterBytes(ConsumerRecord<byte[], Object> record) {
                return record.value() instanceof byte[];
            }

            @Override
            public boolean isInFilter(@Nonnull ConsumerRecord<byte[], Object> record) {
                if (record.value() instanceof DeserializerError) {
                    return true;
                }
                switch (topicContentType) {
                    case BOX: {
                        return this.isInFilterBox(record);
                    }
                    case STR: {
                        return this.isInFilterStr(record);
                    }
                    case BYTES: {
                        return this.isInFilterBytes(record);
                    }
                }
                throw new RuntimeException("zh1gmYyOEP :: Unknown " + TopicContentType.class.getSimpleName() + " " + topicContentType);
            }

            private InvokeResult invokeMethod(Object[] parameters, Profile profile) {
                try {
                    InvokeSessionFactoryControllerBuilder.this.method.invoke(InvokeSessionFactoryControllerBuilder.this.controller, parameters);
                    return InvokeResult.ok();
                }
                catch (IllegalAccessException e) {
                    if (InvokeSessionFactoryControllerBuilder.this.logger.isShow(LoggerType.LOG_CONSUMER_ILLEGAL_ACCESS_EXCEPTION_INVOKING_METHOD)) {
                        InvokeSessionFactoryControllerBuilder.this.logger.logConsumerIllegalAccessExceptionInvoking(e, InvokeSessionFactoryControllerBuilder.infoOf(InvokeSessionFactoryControllerBuilder.this.controller, InvokeSessionFactoryControllerBuilder.this.method));
                    }
                    return InvokeResult.of(false, e);
                }
                catch (InvocationTargetException e) {
                    Throwable error = e.getTargetException();
                    if (InvokeSessionFactoryControllerBuilder.this.logger.isShow(LoggerType.LOG_CONSUMER_ERROR_INVOKING)) {
                        InvokeSessionFactoryControllerBuilder.this.logger.logConsumerErrorInvoking(error, InvokeSessionFactoryControllerBuilder.infoOf(InvokeSessionFactoryControllerBuilder.this.controller, InvokeSessionFactoryControllerBuilder.this.method), profile);
                    }
                    for (Class aClass : commitOn) {
                        if (!aClass.isInstance(error)) continue;
                        return InvokeResult.of(true, error);
                    }
                    return InvokeResult.of(false, error);
                }
            }
        };
        return new InvokeSessionFactoryImpl(this.logger, invoker);
    }

    private static String infoOf(Object controller, Method method) {
        Objects.requireNonNull(controller, "Zub7bmzGC9 :: controller");
        Objects.requireNonNull(method, "cv6Vz6Q7AM :: method");
        return "{method " + method.getName() + " of " + controller.getClass() + " :: " + controller + "}";
    }

    private static Object classOrNull(Class<?> aClass, Object value) {
        return aClass.isInstance(value) ? value : null;
    }

    @Nonnull
    private ParameterValueReader createParameterValueReader(final @Nonnull Type parameterType, @Nonnull Annotation[] parameterAnnotations, TopicContentType topicContentType, ParameterReaderOptions parameterReaderOptions) {
        for (Annotation annotation : parameterAnnotations) {
            if (annotation instanceof Partition) {
                if (!GenericUtil.isOfClass(parameterType, Integer.TYPE) && !GenericUtil.isOfClass(parameterType, Integer.class)) {
                    throw new IllegalParameterType("Parameter with @Partition must be `int` or `Integer`");
                }
                return (record, invokeSessionContext, profile) -> record.partition();
            }
            if (annotation instanceof Offset) {
                if (!GenericUtil.isOfClass(parameterType, Long.TYPE) && !GenericUtil.isOfClass(parameterType, Long.class)) {
                    throw new IllegalParameterType("Parameter with @Offset must be `long` or `Long`");
                }
                return (record, invokeSessionContext, profile) -> record.offset();
            }
            if (annotation instanceof TopicRef) {
                if (!GenericUtil.isOfClass(parameterType, String.class)) {
                    throw new IllegalParameterType("Parameter with @" + TopicRef.class.getSimpleName() + " must be `String`");
                }
                return (record, invokeSessionContext, profile) -> {
                    String topic = record.topic();
                    if (topic == null) {
                        return null;
                    }
                    String prefix = this.topicPrefix.get();
                    if (prefix == null) {
                        return topic;
                    }
                    if (topic.startsWith(prefix)) {
                        return topic.substring(prefix.length());
                    }
                    return topic;
                };
            }
            if (annotation instanceof Timestamp) {
                if (GenericUtil.isOfClass(parameterType, Date.class)) {
                    return (record, invokeSessionContext, profile) -> new Date(record.timestamp());
                }
                if (GenericUtil.isOfClass(parameterType, Long.TYPE) || GenericUtil.isOfClass(parameterType, Long.class)) {
                    return (record, invokeSessionContext, profile) -> record.timestamp();
                }
                throw new IllegalParameterType("Parameter with @Offset must be `long` or `Long` or `java.util.Date`");
            }
            if (annotation instanceof Author) {
                if (!GenericUtil.isOfClass(parameterType, String.class)) {
                    throw new IllegalParameterType("Parameter with @" + Author.class.getSimpleName() + " must be `String`");
                }
                return (record, invokeSessionContext, profile) -> record.value() instanceof Box ? ((Box)record.value()).a : null;
            }
            if (annotation instanceof KafkaId) {
                if (!GenericUtil.isOfClass(parameterType, String.class)) {
                    throw new IllegalParameterType("Parameter with @" + KafkaId.class.getSimpleName() + " must be `String`");
                }
                return (record, invokeSessionContext, profile) -> record.value() instanceof Box ? ((Box)record.value()).id : null;
            }
            if (!(annotation instanceof ProfileRef)) continue;
            if (GenericUtil.isOfClass(parameterType, String.class)) {
                return (record, invokeSessionContext, profile) -> profile.profile;
            }
            if (GenericUtil.isOfClass(parameterType, Profile.class)) {
                return (record, invokeSessionContext, profile) -> profile;
            }
            throw new IllegalParameterType("Parameter with @" + ProfileRef.class.getSimpleName() + " must be `String` or `" + Profile.class.getSimpleName() + "`");
        }
        if (GenericUtil.isOfClass(parameterType, DeserializerError.class)) {
            parameterReaderOptions.acceptDeserializerError();
            return (record, invokeSessionContext, profile) -> InvokeSessionFactoryControllerBuilder.classOrNull(DeserializerError.class, record.value());
        }
        switch (topicContentType) {
            case BOX: {
                if (GenericUtil.isOfClass(parameterType, Box.class)) {
                    return (record, invokeSessionContext, profile) -> InvokeSessionFactoryControllerBuilder.classOrNull(Box.class, record.value());
                }
                return new ParameterValueReader(){

                    @Override
                    public Object read(@Nonnull ConsumerRecord<byte[], Object> record, @Nonnull InvokeSessionContext invokeSessionContext, @Nonnull Profile profile) {
                        Object recordValue = record.value();
                        return recordValue instanceof Box ? ((Box)recordValue).body : null;
                    }

                    @Override
                    public Class<?> gettingBodyClass() {
                        return GenericUtil.extractClass(parameterType);
                    }
                };
            }
            case STR: {
                return new ParameterValueReader(){

                    @Override
                    public Object read(@Nonnull ConsumerRecord<byte[], Object> record, @Nonnull InvokeSessionContext invokeSessionContext, @Nonnull Profile profile) {
                        Object recordValue = record.value();
                        if (recordValue == null) {
                            return null;
                        }
                        if (recordValue instanceof String) {
                            return recordValue;
                        }
                        return recordValue.toString();
                    }

                    @Override
                    public Class<?> gettingBodyClass() {
                        return GenericUtil.extractClass(parameterType);
                    }
                };
            }
            case BYTES: {
                return new ParameterValueReader(){

                    @Override
                    public Object read(@Nonnull ConsumerRecord<byte[], Object> record, @Nonnull InvokeSessionContext invokeSessionContext, @Nonnull Profile profile) {
                        return record.value();
                    }

                    @Override
                    public Class<?> gettingBodyClass() {
                        return GenericUtil.extractClass(parameterType);
                    }
                };
            }
        }
        throw new RuntimeException("9EA0C8P2gE :: Unknown " + TopicContentType.class.getSimpleName() + " = " + topicContentType);
    }

    static interface ParameterReaderOptions {
        public void acceptDeserializerError();
    }
}

