/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.consumer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import kz.greetgo.kafka.consumer.BoxFilter;
import kz.greetgo.kafka.consumer.BoxMetaOnConsumerRecord;
import kz.greetgo.kafka.consumer.CustomBoxConsumer;
import kz.greetgo.kafka.consumer.CustomBytesConsumer;
import kz.greetgo.kafka.consumer.CustomStrConsumer;
import kz.greetgo.kafka.consumer.InvokeResult;
import kz.greetgo.kafka.consumer.InvokeSessionContext;
import kz.greetgo.kafka.consumer.InvokeSessionFactory;
import kz.greetgo.kafka.consumer.InvokeSessionFactoryImpl;
import kz.greetgo.kafka.consumer.Invoker;
import kz.greetgo.kafka.consumer.Profile;
import kz.greetgo.kafka.core.logger.Logger;
import kz.greetgo.kafka.core.logger.LoggerType;
import kz.greetgo.kafka.model.Box;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class InvokeSessionFactoryCustomBuilder {
    private CustomBoxConsumer customBoxConsumer;
    private CustomStrConsumer customStrConsumer;
    private CustomBytesConsumer customBytesConsumer;
    private Logger logger;
    private String consumerName;
    private final List<Class<?>> commitOnList = new ArrayList();
    private BoxFilter boxFilter = (box, key) -> true;

    public InvokeSessionFactoryCustomBuilder customBoxConsumer(CustomBoxConsumer customBoxConsumer) {
        this.customBoxConsumer = customBoxConsumer;
        return this;
    }

    public InvokeSessionFactoryCustomBuilder customStrConsumer(CustomStrConsumer customStrConsumer) {
        this.customStrConsumer = customStrConsumer;
        return this;
    }

    public InvokeSessionFactoryCustomBuilder customBytesConsumer(CustomBytesConsumer customBytesConsumer) {
        this.customBytesConsumer = customBytesConsumer;
        return this;
    }

    public InvokeSessionFactoryCustomBuilder consumerName(String consumerName) {
        this.consumerName = consumerName;
        return this;
    }

    public InvokeSessionFactoryCustomBuilder logger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public InvokeSessionFactoryCustomBuilder commitOn(Class<?> aClass) {
        this.commitOnList.add(aClass);
        return this;
    }

    public InvokeSessionFactoryCustomBuilder commitOnAll(Collection<Class<?>> aClassCollection) {
        aClassCollection.forEach(this::commitOn);
        return this;
    }

    public InvokeSessionFactoryCustomBuilder boxFilter(BoxFilter boxFilter) {
        this.boxFilter = Objects.requireNonNull(boxFilter, "36kb80b3tF :: boxFilter == null");
        return this;
    }

    public InvokeSessionFactory build() {
        if (this.customBoxConsumer == null && this.customStrConsumer == null && this.customBytesConsumer == null) {
            throw new RuntimeException("5WGhRI4RUN :: Consumer function is undefined. Please, define consumer function");
        }
        Objects.requireNonNull(this.boxFilter, "WmXnTYGmSl :: boxFilter");
        return new InvokeSessionFactoryImpl(this.logger, new Invoker(){

            @Override
            public boolean isInFilter(@Nonnull ConsumerRecord<byte[], Object> record) {
                Object x = record.value();
                return x instanceof Box ? InvokeSessionFactoryCustomBuilder.this.boxFilter.isInFilter((Box)x, (byte[])record.key()) : true;
            }

            @Override
            public InvokeResult invoke(@Nonnull ConsumerRecord<byte[], Object> record, @Nonnull InvokeSessionContext context, @Nonnull Profile profile) {
                try {
                    Object message = record.value();
                    BoxMetaOnConsumerRecord boxMeta = new BoxMetaOnConsumerRecord(record, profile);
                    Object c = InvokeSessionFactoryCustomBuilder.this.customBoxConsumer;
                    if (c != null && message instanceof Box) {
                        c.execute((Box)message, boxMeta);
                        return InvokeResult.ok();
                    }
                    c = InvokeSessionFactoryCustomBuilder.this.customStrConsumer;
                    if (c != null && message instanceof CharSequence) {
                        c.execute(message.toString(), boxMeta);
                        return InvokeResult.ok();
                    }
                    c = InvokeSessionFactoryCustomBuilder.this.customBytesConsumer;
                    if (c != null && message instanceof byte[]) {
                        c.execute((byte[])message, boxMeta);
                        return InvokeResult.ok();
                    }
                    throw new RuntimeException("9wfq5yLzGK :: Consumer function is not defined");
                }
                catch (Exception e) {
                    if (InvokeSessionFactoryCustomBuilder.this.logger.isShow(LoggerType.LOG_CONSUMER_ERROR_INVOKING)) {
                        InvokeSessionFactoryCustomBuilder.this.logger.logConsumerErrorInvoking(e, InvokeSessionFactoryCustomBuilder.this.consumerName, profile);
                    }
                    for (Class<?> errorClass : InvokeSessionFactoryCustomBuilder.this.commitOnList) {
                        if (!errorClass.isInstance(e)) continue;
                        return InvokeResult.of(true, e);
                    }
                    return InvokeResult.of(false, e);
                }
            }
        });
    }
}

